/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions;

import jakarta.validation.ConstraintDefinitionException;
import java.lang.reflect.Method;
import java.util.Date;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.ConstraintWithObjectAndObjectArrayValidator;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.ConstraintWithTwoCrossParameterValidators;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.CrossParameterConstraintWithValidationAppliesTo;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.GenericAndCrossParameterConstraintWithValidationAppliesToOfWrongType;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.GenericAndCrossParameterConstraintWithValidationAppliesToWithWrongDefaultValue;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.GenericConstraintWithValidationAppliesTo;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidDefaultGroup;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidDefaultPayload;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidGenericAndCrossParameterConstraint;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidGroupsType;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidMessageType;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.InvalidPayloadClass;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.NoGroups;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.NoMessage;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.NoPayload;
import org.hibernate.beanvalidation.tck.tests.constraints.invalidconstraintdefinitions.ValidInPropertyName;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class InvalidConstraintDefinitionsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)InvalidConstraintDefinitionsTest.webArchiveBuilder().withTestClassPackage(InvalidConstraintDefinitionsTest.class)).build();
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties", id="b"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithParameterStartingWithValid() {
        this.getValidator().validate((Object)new DummyEntityValidProperty(), new Class[0]);
        Assert.fail((String)"The used constraint does use an invalid property name. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-message", id="a"), @SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="b"), @SpecAssertion(section="validationapi-message-defaultmessageinterpolation", id="c"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithoutMessageParameter() {
        this.getValidator().validate((Object)new DummyEntityNoMessage(), new Class[0]);
        Assert.fail((String)"The used constraint does not define a message parameter. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-groups", id="a"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithoutGroupParameter() {
        this.getValidator().validate((Object)new DummyEntityNoGroups(), new Class[0]);
        Assert.fail((String)"The used constraint does not define a groups parameter. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-payload", id="a"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithoutPayloadParameter() {
        this.getValidator().validate((Object)new DummyEntityNoPayload(), new Class[0]);
        Assert.fail((String)"The used constraint does not define a payload parameter. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-groups", id="c"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithWrongDefaultGroupValue() {
        this.getValidator().validate((Object)new DummyEntityInvalidDefaultGroup(), new Class[0]);
        Assert.fail((String)"The default groups parameter is not the empty array. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-payload", id="b"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithWrongDefaultPayloadValue() {
        this.getValidator().validate((Object)new DummyEntityInvalidDefaultPayload(), new Class[0]);
        Assert.fail((String)"The default payload parameter is not the empty array. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-payload", id="a"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-payload", id="c"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithWrongPayloadClass() {
        this.getValidator().validate((Object)new DummyEntityInvalidPayloadClass(), new Class[0]);
        Assert.fail((String)"The default payload parameter has to be of type Class<? extends Payload>[]. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-message", id="a"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithWrongMessageType() {
        this.getValidator().validate((Object)new DummyEntityInvalidMessageType(), new Class[0]);
        Assert.fail((String)"The message parameter has to be of type String. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-groups", id="b"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithWrongGroupType() {
        this.getValidator().validate((Object)new DummyEntityInvalidGroupsType(), new Class[0]);
        Assert.fail((String)"The groups parameter has to be of type Class<?>[]. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="g")
    public void testValidatorForCrossParameterConstraintMustValidateObjectOrObjectArray() throws Exception {
        CalendarService object = new CalendarService();
        Method method = CalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"Validators for cross-parameter constraints must validate the type Object or Object[]. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="f")
    public void testCrossParameterConstraintWithSeveralValidatorsCausesException() throws Exception {
        OnlineCalendarService object = new OnlineCalendarService();
        Method method = OnlineCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"There must be only one validator for a cross-parameter constraint. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="f")
    public void testCrossParameterConstraintWithValidatorForObjectAndObjectArrayCausesException() throws Exception {
        AdvancedCalendarService object = new AdvancedCalendarService();
        Method method = AdvancedCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"There must be only one validator for a cross-parameter constraint. Expected exception wasn't thrown.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-validationappliesto", id="a"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testGenericAndCrossParameterConstraintWithoutValidationAppliesToCausesException() {
        this.getValidator().validate((Object)new DummyEntityNoValidationAppliesTo(), new Class[0]);
        Assert.fail((String)"A constraint which is generic and cross-parameter needs to define a member validationAppliesTo. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-validationappliesto", id="a"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testGenericConstraintWithValidationAppliesToCausesException() {
        this.getValidator().validate((Object)new DummyEntityWithUnexpectedValidationAppliesTo(), new Class[0]);
        Assert.fail((String)"A pure generic constraint must not define a member validationAppliesTo. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-validationappliesto", id="a"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testCrossParameterConstraintWithValidationAppliesToCausesException() throws Exception {
        PaperCalendarService object = new PaperCalendarService();
        Method method = PaperCalendarService.class.getMethod("createEvent", Date.class, Date.class);
        Object[] parameterValues = new Object[2];
        this.getExecutableValidator().validateParameters((Object)object, method, parameterValues, new Class[0]);
        Assert.fail((String)"A pure cross-parameter constraint must not define a member validationAppliesTo. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-validationappliesto", id="b"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithWrongValidationAppliesToType() {
        this.getValidator().validate((Object)new DummyEntityWithValidationAppliesToOfWrongType(), new Class[0]);
        Assert.fail((String)"The validationAppliesTo parameter has to be of type ConstraintTarget. The validation should have failed.");
    }

    @Test(expectedExceptions={ConstraintDefinitionException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition", id="g"), @SpecAssertion(section="constraintsdefinitionimplementation-constraintdefinition-properties-validationappliesto", id="b"), @SpecAssertion(section="exception-constraintdefinition", id="a")})
    public void testConstraintDefinitionWithWrongDefaultValidationAppliesTo() {
        this.getValidator().validate((Object)new DummyEntityWithValidationAppliesToWithWrongDefaultValue(), new Class[0]);
        Assert.fail((String)"The validationAppliesTo parameter must have a default value of ConstraintTarget.IMPLICIT. The validation should have failed.");
    }

    @ValidInPropertyName
    public class DummyEntityValidProperty {
    }

    @NoMessage
    public class DummyEntityNoMessage {
    }

    @NoGroups
    public class DummyEntityNoGroups {
    }

    @NoPayload
    public class DummyEntityNoPayload {
    }

    @InvalidDefaultGroup
    public class DummyEntityInvalidDefaultGroup {
    }

    @InvalidDefaultPayload
    public class DummyEntityInvalidDefaultPayload {
    }

    @InvalidPayloadClass
    public class DummyEntityInvalidPayloadClass {
    }

    @InvalidMessageType
    public class DummyEntityInvalidMessageType {
    }

    @InvalidGroupsType
    public class DummyEntityInvalidGroupsType {
    }

    private static class CalendarService {
        private CalendarService() {
        }

        @InvalidCrossParameterConstraint
        public void createEvent(Date start, Date end) {
        }
    }

    private static class OnlineCalendarService {
        private OnlineCalendarService() {
        }

        @ConstraintWithTwoCrossParameterValidators
        public void createEvent(Date start, Date end) {
        }
    }

    private static class AdvancedCalendarService {
        private AdvancedCalendarService() {
        }

        @ConstraintWithObjectAndObjectArrayValidator
        public void createEvent(Date start, Date end) {
        }
    }

    @InvalidGenericAndCrossParameterConstraint
    private static class DummyEntityNoValidationAppliesTo {
        private DummyEntityNoValidationAppliesTo() {
        }
    }

    @GenericConstraintWithValidationAppliesTo
    private static class DummyEntityWithUnexpectedValidationAppliesTo {
        private DummyEntityWithUnexpectedValidationAppliesTo() {
        }
    }

    private static class PaperCalendarService {
        private PaperCalendarService() {
        }

        @CrossParameterConstraintWithValidationAppliesTo
        public void createEvent(Date start, Date end) {
        }
    }

    @GenericAndCrossParameterConstraintWithValidationAppliesToOfWrongType
    private static class DummyEntityWithValidationAppliesToOfWrongType {
        private DummyEntityWithValidationAppliesToOfWrongType() {
        }
    }

    @GenericAndCrossParameterConstraintWithValidationAppliesToWithWrongDefaultValue
    private static class DummyEntityWithValidationAppliesToWithWrongDefaultValue {
        private DummyEntityWithValidationAppliesToWithWrongDefaultValue() {
        }
    }
}

