/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.time;

import jakarta.validation.ClockProvider;
import jakarta.validation.Configuration;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.Payload;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.constraints.Past;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.time.FixedClockProvider;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class ClockProviderTest
extends AbstractTCKTest {
    private static final long ACCEPTABLE_CLOCK_DEVIATION_IN_MS = 10L;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)ClockProviderTest.webArchiveBuilder().withTestClassPackage(ClockProviderTest.class)).build();
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-configuration", id="e")
    public void testDefaultClockProviderProvidedByConfiguration() {
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        Assert.assertNotNull((Object)config.getDefaultClockProvider());
        ClockProviderTest.checkClockProviderHasDefaultProperties(config.getDefaultClockProvider());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation-temporalvalidators", id="a"), @SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation-temporalvalidators", id="b")})
    public void testClockProviderProviderByConstraintValidatorContext() {
        TestUtil.getValidatorUnderTest().validate((Object)new DefaultClockProviderIsValidEntity(), new Class[0]);
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-validatorfactory", id="f")
    public void testCustomClockProviderFromValidatorFactory() {
        Configuration<?> configuration = TestUtil.getConfigurationUnderTest();
        CustomClockProvider clockProvider = new CustomClockProvider();
        configuration.clockProvider((ClockProvider)clockProvider);
        ValidatorFactory factory = configuration.buildValidatorFactory();
        Assert.assertSame((Object)factory.getClockProvider(), (Object)clockProvider);
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-validatorfactory", id="f")
    public void testCustomClockProviderViaConfiguration() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Person person = new Person();
        person.setBirthday(Instant.now().minus(Duration.ofDays(15L)));
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        person.setBirthday(Instant.now().plus(Duration.ofDays(15L)));
        constraintViolations = validator.validate((Object)person, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("birthday"));
        validator = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)new FixedClockProvider(ZonedDateTime.now().plus(Duration.ofDays(60L)))).buildValidatorFactory().getValidator();
        person.setBirthday(Instant.now().plus(Duration.ofDays(15L)));
        constraintViolations = validator.validate((Object)person, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
        person.setBirthday(Instant.now().plus(Duration.ofDays(90L)));
        constraintViolations = validator.validate((Object)person, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("birthday"));
    }

    @Test(expectedExceptions={ValidationException.class})
    @SpecAssertions(value={@SpecAssertion(section="constraintsdefinitionimplementation-validationimplementation", id="n"), @SpecAssertion(section="exception", id="a")})
    public void testClockProviderExceptionsGetWrappedInValidationException() {
        ExceptionThrowingClockProvider clockProvider = new ExceptionThrowingClockProvider();
        Configuration config = TestUtil.getConfigurationUnderTest().clockProvider((ClockProvider)clockProvider);
        ValidatorFactory factory = config.buildValidatorFactory();
        Validator v = factory.getValidator();
        Person person = new Person();
        person.setBirthday(Instant.now().minus(Duration.ofDays(3L)));
        v.validate((Object)person, new Class[0]);
    }

    @Test
    @SpecAssertion(section="validationapi-bootstrapping-validatorfactory", id="g")
    public void canConfigureClockProviderForValidator() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Person person = new Person();
        person.setBirthday(Instant.now().plus(Duration.ofDays(15L)));
        Set constraintViolations = validator.validate((Object)person, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyPaths(ConstraintViolationAssert.pathWith().property("birthday"));
        validator = TestUtil.getValidatorFactoryUnderTest().usingContext().clockProvider((ClockProvider)new FixedClockProvider(ZonedDateTime.now().plus(Duration.ofDays(60L)))).getValidator();
        constraintViolations = validator.validate((Object)person, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    private static void checkClockProviderHasDefaultProperties(ClockProvider clockProvider) {
        Clock clock = clockProvider.getClock();
        Clock systemClock = Clock.systemDefaultZone();
        if (!systemClock.getZone().equals(clock.getZone())) {
            throw new AssertionError((Object)"The default clock provider should use the default system time zone.");
        }
        if (Math.abs(clock.millis() - systemClock.millis()) > 10L) {
            throw new AssertionError((Object)"The default clock provider should return the system time.");
        }
    }

    private static class DefaultClockProviderIsValidEntity {
        @DefaultClockProviderIsValid
        private LocalDateTime localDateTime;

        private DefaultClockProviderIsValidEntity() {
        }
    }

    private static class CustomClockProvider
    implements ClockProvider {
        private CustomClockProvider() {
        }

        public Clock getClock() {
            return Clock.systemDefaultZone();
        }
    }

    private static class Person {
        @Past
        private Instant birthday;

        private Person() {
        }

        public void setBirthday(Instant birthday) {
            this.birthday = birthday;
        }
    }

    private static class ExceptionThrowingClockProvider
    implements ClockProvider {
        private ExceptionThrowingClockProvider() {
        }

        public Clock getClock() {
            throw new RuntimeException("This clock provider throws an exception that should be wrapped in a ValidationException");
        }
    }

    public static class DefaultClockProviderValidator
    implements ConstraintValidator<DefaultClockProviderIsValid, LocalDateTime> {
        public boolean isValid(LocalDateTime localDateTime, ConstraintValidatorContext constraintValidatorContext) {
            ClockProviderTest.checkClockProviderHasDefaultProperties(constraintValidatorContext.getClockProvider());
            return true;
        }
    }

    @Constraint(validatedBy={DefaultClockProviderValidator.class})
    @Documented
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DefaultClockProviderIsValid {
        public String message() default "Default clock provider is invalid.";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }
}

