/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Collection;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.IterableUtil;

public class ShouldOnlyHaveFields
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldOnlyHaveFields(Class<?> actual, Collection<String> expected, Collection<String> notFound, Collection<String> notExpected) {
        return ShouldOnlyHaveFields.create(actual, expected, notFound, notExpected, false);
    }

    public static ErrorMessageFactory shouldOnlyHaveDeclaredFields(Class<?> actual, Collection<String> expected, Collection<String> notFound, Collection<String> notExpected) {
        return ShouldOnlyHaveFields.create(actual, expected, notFound, notExpected, true);
    }

    private static ErrorMessageFactory create(Class<?> actual, Collection<String> expected, Collection<String> notFound, Collection<String> notExpected, boolean declared) {
        if (IterableUtil.isNullOrEmpty(notExpected)) {
            return new ShouldOnlyHaveFields(actual, expected, notFound, ErrorType.NOT_FOUND_ONLY, declared);
        }
        if (IterableUtil.isNullOrEmpty(notFound)) {
            return new ShouldOnlyHaveFields(actual, expected, notExpected, ErrorType.NOT_EXPECTED_ONLY, declared);
        }
        return new ShouldOnlyHaveFields(actual, expected, notFound, notExpected, declared);
    }

    private ShouldOnlyHaveFields(Class<?> actual, Collection<String> expected, Collection<String> notFound, Collection<String> notExpected, boolean declared) {
        super("%nExpecting%n  %s%nto only have the following " + (declared ? "declared" : "public accessible") + " fields:%n  %s%nfields not found:%n  %s%nand fields not expected:%n  %s", actual, expected, notFound, notExpected);
    }

    private ShouldOnlyHaveFields(Class<?> actual, Collection<String> expected, Collection<String> notFoundOrNotExpected, ErrorType errorType, boolean declared) {
        super("%nExpecting%n  %s%nto only have the following " + (declared ? "declared" : "public accessible") + " fields:%n  %s%n" + (errorType == ErrorType.NOT_FOUND_ONLY ? "but could not find the following fields:%n" : "but the following fields were unexpected:%n") + "  %s", actual, expected, notFoundOrNotExpected);
    }

    static enum ErrorType {
        NOT_FOUND_ONLY,
        NOT_EXPECTED_ONLY;

    }
}

