/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.ContainerElementTypeDescriptor;
import jakarta.validation.metadata.GroupConversionDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.BasicChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.ComplexChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.ComplexOrder;
import org.hibernate.beanvalidation.tck.tests.metadata.ComplexProductTypeChecks;
import org.hibernate.beanvalidation.tck.tests.metadata.Customer;
import org.hibernate.beanvalidation.tck.tests.metadata.MetaDataTestUtil;
import org.hibernate.beanvalidation.tck.tests.metadata.Order;
import org.hibernate.beanvalidation.tck.tests.metadata.ProductOrderLine;
import org.hibernate.beanvalidation.tck.tests.metadata.ProductType;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class PropertyDescriptorTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)PropertyDescriptorTest.webArchiveBuilder().withTestClassPackage(PropertyDescriptorTest.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-elementdescriptor", id="a")
    public void testGetElementClass() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Order.class, "orderNumber");
        Assert.assertEquals((Object)descriptor.getElementClass(), Integer.class, (String)"Wrong element class");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsNotCascaded() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Order.class, "orderNumber");
        Assert.assertFalse((boolean)descriptor.isCascaded(), (String)"Should not be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="a")
    public void testIsCascaded() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "orderList");
        Assert.assertTrue((boolean)descriptor.isCascaded(), (String)"Should be cascaded");
    }

    @Test
    @SpecAssertion(section="constraintmetadata-propertydescriptor", id="a")
    public void testPropertyName() {
        String propertyName = "orderList";
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, propertyName);
        Assert.assertEquals((String)descriptor.getPropertyName(), (String)propertyName, (String)"Wrong property name");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForField() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "orderList");
        Set groupConversions = descriptor.getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(Customer.StrictCustomerChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), Customer.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="a"), @SpecAssertion(section="constraintmetadata-groupconversiondescriptor", id="b")})
    public void testGetGroupConversionsForProperty() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "account");
        Set groupConversions = descriptor.getGroupConversions();
        Assert.assertEquals((int)groupConversions.size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : groupConversions) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(Customer.StrictCustomerChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), Customer.StrictChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
    }

    @Test
    @SpecAssertion(section="constraintmetadata-cascadabledescriptor", id="b")
    public void testGetGroupConversionsReturnsEmptySet() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(Customer.class, "firstName");
        Set groupConversions = descriptor.getGroupConversions();
        Assert.assertNotNull((Object)groupConversions);
        Assert.assertTrue((boolean)groupConversions.isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintmetadata-elementdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="a"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="c"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="d"), @SpecAssertion(section="constraintmetadata-containerdescriptor", id="e")})
    public void testGetContainerElementMetaData() {
        PropertyDescriptor descriptor = TestUtil.getPropertyDescriptor(ComplexOrder.class, "orderLines");
        Set containerElementTypes = descriptor.getConstrainedContainerElementTypes();
        Assert.assertEquals((int)containerElementTypes.size(), (int)2);
        ContainerElementTypeDescriptor productType = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypes, Map.class, 0);
        Assert.assertEquals((Object)productType.getElementClass(), ProductType.class);
        MetaDataTestUtil.assertConstraintDescriptors(productType.getConstraintDescriptors(), NotNull.class);
        Assert.assertEquals((int)productType.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertTrue((boolean)productType.isCascaded());
        Assert.assertEquals((int)productType.getGroupConversions().size(), (int)2);
        for (GroupConversionDescriptor groupConversionDescriptor : productType.getGroupConversions()) {
            if (groupConversionDescriptor.getFrom().equals(Default.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), BasicChecks.class);
                continue;
            }
            if (groupConversionDescriptor.getFrom().equals(ComplexChecks.class)) {
                Assert.assertEquals((Object)groupConversionDescriptor.getTo(), ComplexProductTypeChecks.class);
                continue;
            }
            Assert.fail((String)String.format("Encountered unexpected group conversion from %s to %s", groupConversionDescriptor.getFrom().getName(), groupConversionDescriptor.getTo().getName()));
        }
        ContainerElementTypeDescriptor orderLineList = MetaDataTestUtil.getContainerElementDescriptor(containerElementTypes, Map.class, 1);
        Assert.assertEquals((Object)orderLineList.getElementClass(), List.class);
        MetaDataTestUtil.assertConstraintDescriptors(orderLineList.getConstraintDescriptors(), Size.class);
        Assert.assertFalse((boolean)orderLineList.isCascaded());
        Assert.assertEquals((int)orderLineList.getGroupConversions().size(), (int)0);
        Assert.assertEquals((int)orderLineList.getConstrainedContainerElementTypes().size(), (int)1);
        ContainerElementTypeDescriptor orderLine = MetaDataTestUtil.getContainerElementDescriptor(orderLineList.getConstrainedContainerElementTypes(), List.class, 0);
        Assert.assertEquals((Object)orderLine.getElementClass(), ProductOrderLine.class);
        MetaDataTestUtil.assertConstraintDescriptors(orderLine.getConstraintDescriptors(), NotNull.class);
        Assert.assertEquals((int)orderLine.getConstrainedContainerElementTypes().size(), (int)0);
        Assert.assertFalse((boolean)orderLine.isCascaded());
    }
}

