/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.async;

import java.io.IOException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import org.jboss.cdi.tck.tests.context.request.async.SimpleRequestBean;
import org.jboss.cdi.tck.tests.context.request.async.StatusBean;
import org.jboss.cdi.tck.util.SimpleLogger;

public class SimpleAsyncListener
implements AsyncListener {
    public static boolean isRequestContextActive = false;
    private static final SimpleLogger logger = new SimpleLogger(SimpleAsyncListener.class);
    @Inject
    SimpleRequestBean simpleRequestBean;
    @Inject
    BeanManager beanManager;
    @Inject
    StatusBean statusBean;

    public void onComplete(AsyncEvent event) throws IOException {
        logger.log("onComplete", new Object[0]);
        if (!this.statusBean.isOnTimeout() && !this.statusBean.isOnError()) {
            this.statusBean.setOnComplete(this.checkRequestContextAvailability());
        }
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        logger.log("onTimeout", new Object[0]);
        this.statusBean.setOnTimeout(this.checkRequestContextAvailability());
        event.getAsyncContext().complete();
    }

    public void onError(AsyncEvent event) throws IOException {
        logger.log("onError", new Object[0]);
        this.statusBean.setOnError(this.checkRequestContextAvailability());
        event.getAsyncContext().complete();
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        logger.log("onStartAsync", new Object[0]);
        this.statusBean.setOnStartAsync(this.checkRequestContextAvailability());
    }

    private boolean checkRequestContextAvailability() throws IOException {
        try {
            this.statusBean.setRequestBeanId(this.simpleRequestBean.getId());
            isRequestContextActive = this.beanManager.getContext(RequestScoped.class).isActive();
        }
        catch (Throwable e) {
            logger.log("Problem while checking request scope: " + e.getMessage(), new Object[0]);
        }
        return isRequestContextActive && this.statusBean.getRequestBeanId() != null;
    }
}

