/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.fires;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.extensions.beanManager.broken.event.ContainerLifecycleEvents;

@RequestScoped
public class ContainerLifecycleEventDispatcher {
    @Inject
    Event<Object> event;

    public void fireContainerLifecycleEvents() {
        this.tryFire(AfterBeanDiscovery.class, ContainerLifecycleEvents.AFTER_BEAN_DISCOVERY);
        this.tryFire(AfterDeploymentValidation.class, ContainerLifecycleEvents.AFTER_DEPLOYMENT_VALIDATION);
        this.tryFire(BeforeShutdown.class, ContainerLifecycleEvents.BEFORE_SHUTDOWN);
        this.tryFire(ProcessAnnotatedType.class, ContainerLifecycleEvents.PROCESS_ANNOTATED_TYPE);
        this.tryFire(ProcessInjectionPoint.class, ContainerLifecycleEvents.PROCESS_INJECTION_POINT);
        this.tryFire(ProcessInjectionTarget.class, ContainerLifecycleEvents.PROCESS_INJECTION_TARGET);
        this.tryFire(ProcessProducer.class, ContainerLifecycleEvents.PROCESS_PRODUCER);
        this.tryFire(ProcessBeanAttributes.class, ContainerLifecycleEvents.PROCESS_BEAN_ATTRIBUTES);
        this.tryFire(ProcessBean.class, ContainerLifecycleEvents.PROCESS_BEAN);
        this.tryFire(ProcessObserverMethod.class, ContainerLifecycleEvents.PROCESS_OBSERVER_METHOD);
        this.tryFire(ProcessSessionBean.class, ContainerLifecycleEvents.PROCESS_SESSION_BEAN);
        this.tryFire(ProcessProducerField.class, ContainerLifecycleEvents.PROCESS_PRODUCER_FIELD);
        this.tryFire(ProcessProducerMethod.class, ContainerLifecycleEvents.PROCESS_PRODUCER_METHOD);
        this.tryFire(BeforeBeanDiscovery.class, ContainerLifecycleEvents.BEFORE_BEAN_DISCOVERY);
    }

    private <T> void tryFire(Class<T> clazz, T payload) {
        try {
            this.event.select(clazz, new Annotation[0]).fire(payload);
            throw new IllegalStateException("Expected exception (IllegalArgumentException) not thrown");
        }
        catch (IllegalArgumentException expected) {
            expected.getCause();
            return;
        }
    }
}

