/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.select;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import org.jboss.cdi.tck.tests.event.select.BreakInEvent;
import org.jboss.cdi.tck.tests.event.select.SecurityEvent;
import org.jboss.cdi.tck.tests.event.select.SystemTest;
import org.jboss.cdi.tck.tests.event.select.Violent;

@RequestScoped
class AlarmSystem {
    private int numSecurityEvents = 0;
    private int numSystemTests = 0;
    private int numBreakIns = 0;
    private int numViolentBreakIns = 0;

    AlarmSystem() {
    }

    public void securityEventOccurred(@Observes @Any SecurityEvent event) {
        ++this.numSecurityEvents;
    }

    public void selfTest(@Observes @SystemTest SecurityEvent event) {
        ++this.numSystemTests;
    }

    public void breakInOccurred(@Observes @Any BreakInEvent event) {
        ++this.numBreakIns;
    }

    public void securityBreeched(@Observes @Violent BreakInEvent event) {
        ++this.numViolentBreakIns;
    }

    public int getNumSystemTests() {
        return this.numSystemTests;
    }

    public int getNumSecurityEvents() {
        return this.numSecurityEvents;
    }

    public int getNumBreakIns() {
        return this.numBreakIns;
    }

    public int getNumViolentBreakIns() {
        return this.numViolentBreakIns;
    }

    public void reset() {
        this.numBreakIns = 0;
        this.numViolentBreakIns = 0;
        this.numSecurityEvents = 0;
        this.numSystemTests = 0;
    }
}

