/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition;

import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.Atomic;
import org.jboss.cdi.tck.tests.interceptors.definition.AtomicFoo;
import org.jboss.cdi.tck.tests.interceptors.definition.AtomicInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.FileLogger;
import org.jboss.cdi.tck.tests.interceptors.definition.Logged;
import org.jboss.cdi.tck.tests.interceptors.definition.MissileBinding;
import org.jboss.cdi.tck.tests.interceptors.definition.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.NetworkLogger;
import org.jboss.cdi.tck.tests.interceptors.definition.NonBindingType;
import org.jboss.cdi.tck.tests.interceptors.definition.NotEnabledAtomicInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.Secure;
import org.jboss.cdi.tck.tests.interceptors.definition.SecureInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.SecureTransaction;
import org.jboss.cdi.tck.tests.interceptors.definition.Transactional;
import org.jboss.cdi.tck.tests.interceptors.definition.TransactionalInterceptor;
import org.jboss.cdi.tck.util.HierarchyDiscovery;
import org.jboss.cdi.tck.util.ParameterizedTypeImpl;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class InterceptorDefinitionTest
extends AbstractTest {
    private static final Transactional.TransactionalLiteral TRANSACTIONAL_LITERAL = new Transactional.TransactionalLiteral(""){};
    private static final AnnotationLiteral<Secure> SECURE_LITERAL = new AnnotationLiteral<Secure>(){};
    private static final AnnotationLiteral<MissileBinding> MISSILE_LITERAL = new AnnotationLiteral<MissileBinding>(){};
    private static final AnnotationLiteral<Logged> LOGGED_LITERAL = new AnnotationLiteral<Logged>(){};
    private static final AnnotationLiteral<Atomic> ATOMIC_LITERAL = new AnnotationLiteral<Atomic>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="interceptor", id="a")})
    public void testInterceptorsImplementInterceptorInterface() {
        boolean interfaceFound = false;
        for (Type type : this.getInterfacesImplemented(this.getTransactionalInterceptor().getClass())) {
            if (!(type instanceof ParameterizedTypeImpl) || !((ParameterizedTypeImpl)type).getRawType().equals(Interceptor.class)) continue;
            interfaceFound = true;
            break;
        }
        Assert.assertTrue((boolean)interfaceFound);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="interceptor", id="b")})
    public void testInterceptorBindingTypes() {
        Interceptor<?> interceptorBean = this.getTransactionalInterceptor();
        Assert.assertEquals((int)interceptorBean.getInterceptorBindings().size(), (int)1);
        Assert.assertTrue((boolean)interceptorBean.getInterceptorBindings().contains(TRANSACTIONAL_LITERAL));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="interceptor", id="c"), @SpecAssertion(section="interceptor", id="e"), @SpecAssertion(section="interceptor_ee", id="a")})
    public void testInterceptionType() {
        Interceptor<?> interceptorBean = this.getTransactionalInterceptor();
        Assert.assertTrue((boolean)interceptorBean.intercepts(InterceptionType.AROUND_INVOKE));
        Assert.assertFalse((boolean)interceptorBean.intercepts(InterceptionType.POST_ACTIVATE));
        Assert.assertFalse((boolean)interceptorBean.intercepts(InterceptionType.POST_CONSTRUCT));
        Assert.assertFalse((boolean)interceptorBean.intercepts(InterceptionType.PRE_DESTROY));
        Assert.assertFalse((boolean)interceptorBean.intercepts(InterceptionType.PRE_PASSIVATE));
        Assert.assertFalse((boolean)interceptorBean.intercepts(InterceptionType.AROUND_TIMEOUT));
    }

    @Test
    @SpecAssertion(section="interceptor", id="f")
    public void testInstanceOfInterceptorForEveryEnabledInterceptor() {
        List<AnnotationLiteral> annotationLiterals = Arrays.asList(TRANSACTIONAL_LITERAL, SECURE_LITERAL, MISSILE_LITERAL, LOGGED_LITERAL);
        ArrayList<Class> interceptorClasses = new ArrayList<Class>(Arrays.asList(AtomicInterceptor.class, MissileInterceptor.class, SecureInterceptor.class, TransactionalInterceptor.class, NetworkLogger.class, FileLogger.class, NotEnabledAtomicInterceptor.class));
        for (AnnotationLiteral annotationLiteral : annotationLiterals) {
            List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{annotationLiteral});
            for (Interceptor interceptor : interceptors) {
                interceptorClasses.remove(interceptor.getBeanClass());
            }
        }
        List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{ATOMIC_LITERAL, MISSILE_LITERAL});
        for (Interceptor interceptor : interceptors) {
            interceptorClasses.remove(interceptor.getBeanClass());
        }
        Assert.assertEquals((int)interceptorClasses.size(), (int)1);
        Assert.assertEquals(interceptorClasses.get(0), NotEnabledAtomicInterceptor.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_interceptor_resolution", id="a")})
    public void testResolveInterceptorsReturnsOrderedList() {
        List interceptors = this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{TRANSACTIONAL_LITERAL, SECURE_LITERAL});
        Assert.assertEquals((int)interceptors.size(), (int)2);
        Assert.assertEquals((int)((Interceptor)interceptors.get(0)).getInterceptorBindings().size(), (int)1);
        Assert.assertTrue((boolean)((Interceptor)interceptors.get(0)).getInterceptorBindings().contains(SECURE_LITERAL));
        Assert.assertEquals((int)((Interceptor)interceptors.get(1)).getInterceptorBindings().size(), (int)1);
        Assert.assertTrue((boolean)((Interceptor)interceptors.get(1)).getInterceptorBindings().contains(TRANSACTIONAL_LITERAL));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="bm_interceptor_resolution", id="b")})
    public void testSameBindingTypesToResolveInterceptorsFails() {
        this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new Transactional.TransactionalLiteral("a"), new Transactional.TransactionalLiteral("b")});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="bm_interceptor_resolution", id="c")})
    public void testNoBindingTypesToResolveInterceptorsFails() {
        this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[0]);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertions(value={@SpecAssertion(section="bm_interceptor_resolution", id="d")})
    public void testNonBindingTypeToResolveInterceptorsFails() {
        AnnotationLiteral<NonBindingType> nonBinding = new AnnotationLiteral<NonBindingType>(){};
        this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{nonBinding});
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="binding_interceptor_to_bean", id="a")})
    public void testInterceptorBindingAnnotation() {
        List<Interceptor<?>> interceptors = this.getLoggedInterceptors();
        Assert.assertTrue((interceptors.size() > 1 ? 1 : 0) != 0);
        Interceptor<?> interceptorBean = interceptors.iterator().next();
        Assert.assertEquals((int)interceptorBean.getInterceptorBindings().size(), (int)1);
        Assert.assertTrue((boolean)interceptorBean.getInterceptorBindings().contains(LOGGED_LITERAL));
        Target target = ((Annotation)interceptorBean.getInterceptorBindings().iterator().next()).annotationType().getAnnotation(Target.class);
        List<ElementType> elements = Arrays.asList(target.value());
        Assert.assertTrue((boolean)elements.contains((Object)ElementType.TYPE));
        Assert.assertTrue((boolean)elements.contains((Object)ElementType.METHOD));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotype_interceptor_bindings", id="a"), @SpecAssertion(section="stereotype_interceptor_bindings", id="b"), @SpecAssertion(section="specify_stereotype_interceptor_bindings", id="b")})
    public void testStereotypeInterceptorBindings() {
        FileLogger.intercepted = false;
        NetworkLogger.intercepted = false;
        SecureTransaction secureTransaction = this.getContextualReference(SecureTransaction.class, new Annotation[0]);
        secureTransaction.transact();
        Assert.assertTrue((boolean)FileLogger.intercepted);
        Assert.assertTrue((boolean)NetworkLogger.intercepted);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="binding_interceptor_to_bean", id="a")})
    public void testInterceptorBindingsCanDeclareOtherInterceptorBindings() {
        AtomicInterceptor.intercepted = false;
        MissileInterceptor.intercepted = false;
        AtomicFoo foo = this.getContextualReference(AtomicFoo.class, new Annotation[0]);
        foo.doAction();
        Assert.assertTrue((boolean)AtomicInterceptor.intercepted);
        Assert.assertTrue((boolean)MissileInterceptor.intercepted);
    }

    private Interceptor<?> getTransactionalInterceptor() {
        return (Interceptor)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{TRANSACTIONAL_LITERAL}).iterator().next();
    }

    private List<Interceptor<?>> getLoggedInterceptors() {
        return this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Logged>(){}});
    }

    private Set<Type> getInterfacesImplemented(Class<?> clazz) {
        HashSet<Type> interfaces = new HashSet<Type>();
        interfaces.addAll(new HierarchyDiscovery(clazz).getFlattenedTypes());
        return interfaces;
    }
}

