/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.IllegalProductException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.BrownRecluse;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.Fail;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.FirstBorn;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.FooException;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.Lorry;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.Null;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.Pet;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.PotatoChip;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.Ship;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.Spider;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.SpiderEgg;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.SpiderProducer;
import org.jboss.cdi.tck.tests.implementation.producer.method.lifecycle.Tarantula;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class ProducerMethodLifecycleTest
extends AbstractTest {
    private AnnotationLiteral<Pet> PET_LITERAL = new AnnotationLiteral<Pet>(){};
    private AnnotationLiteral<FirstBorn> FIRST_BORN_LITERAL = new AnnotationLiteral<FirstBorn>(){};
    private AnnotationLiteral<Fail> FAIL_LITERAL = new AnnotationLiteral<Fail>(){};
    private AnnotationLiteral<Null> NULL_LITERAL = new AnnotationLiteral<Null>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerMethodLifecycleTest.class)).build();
    }

    @Test
    @SpecAssertion(section="producer_method_lifecycle", id="ea")
    public void testProducerMethodBeanCreate() {
        SpiderProducer.reset();
        Bean<Tarantula> tarantulaBean = this.getBeans(Tarantula.class, new Annotation[]{this.PET_LITERAL}).iterator().next();
        CreationalContext tarantulaCc = this.getCurrentManager().createCreationalContext(tarantulaBean);
        Tarantula tarantula = (Tarantula)tarantulaBean.create(tarantulaCc);
        assert (SpiderProducer.getTarantulaCreated() == tarantula);
        assert (SpiderProducer.getInjectedWeb() != null);
        assert (SpiderProducer.getInjectedWeb().isDestroyed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method_lifecycle", id="ea")})
    public void testProducerMethodInvokedOnCreate() {
        Bean<SpiderEgg> eggBean = this.getBeans(SpiderEgg.class, new Annotation[]{this.FIRST_BORN_LITERAL}).iterator().next();
        CreationalContext eggCc = this.getCurrentManager().createCreationalContext(eggBean);
        assert (eggBean.create(eggCc) != null);
    }

    @Test
    @SpecAssertion(section="producer_method", id="j")
    public void testWhenApplicationInvokesProducerMethodParametersAreNotInjected() {
        try {
            this.getContextualReference(BrownRecluse.class, new Annotation[0]).layAnEgg(null);
        }
        catch (AssertionError e) {
            return;
        }
        assert (false) : "The BeanManager should not have been injected into the producer method";
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method_lifecycle", id="k")})
    public void testCreateReturnsNullIfProducerDoesAndDependent() {
        Bean<Spider> nullSpiderBean = this.getBeans(Spider.class, new Annotation[]{this.NULL_LITERAL}).iterator().next();
        CreationalContext nullSpiderBeanCc = this.getCurrentManager().createCreationalContext(nullSpiderBean);
        assert (nullSpiderBean.create(nullSpiderBeanCc) == null);
    }

    @Test(expectedExceptions={IllegalProductException.class})
    @SpecAssertions(value={@SpecAssertion(section="producer_method_lifecycle", id="l")})
    public void testCreateFailsIfProducerReturnsNullAndNotDependent() {
        Bean<PotatoChip> potatoChipBean = this.getBeans(PotatoChip.class, new Annotation[]{this.NULL_LITERAL}).iterator().next();
        assert (potatoChipBean != null);
        CreationalContext chipCc = this.getCurrentManager().createCreationalContext(potatoChipBean);
        potatoChipBean.create(chipCc);
        assert (false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_method_lifecycle", id="ma"), @SpecAssertion(section="producer_method_lifecycle", id="r")})
    public void testProducerMethodBeanDestroy() {
        SpiderProducer.reset();
        Set beans = this.getCurrentManager().getBeans(Tarantula.class, new Annotation[]{this.PET_LITERAL});
        Bean bean = this.getCurrentManager().resolve(beans);
        assert (bean.getBeanClass().equals(SpiderProducer.class));
        assert (bean.getTypes().contains(Tarantula.class));
        Bean tarantulaBean = bean;
        CreationalContext tarantulaCc = this.getCurrentManager().createCreationalContext((Contextual)tarantulaBean);
        Tarantula tarantula = (Tarantula)tarantulaBean.create(tarantulaCc);
        SpiderProducer.resetInjections();
        tarantulaBean.destroy((Object)tarantula, tarantulaCc);
        assert (SpiderProducer.getTarantulaDestroyed() == tarantula);
        assert (SpiderProducer.isDestroyArgumentsSet());
        assert (SpiderProducer.getInjectedWeb() != null);
        assert (SpiderProducer.getInjectedWeb().isDestroyed());
    }

    @Test(expectedExceptions={FooException.class})
    @SpecAssertions(value={@SpecAssertion(section="contextual", id="aa")})
    public void testCreateRethrowsUncheckedException() {
        Bean<Ship> shipBean = this.getBeans(Ship.class, new Annotation[]{this.FAIL_LITERAL}).iterator().next();
        CreationalContext shipCc = this.getCurrentManager().createCreationalContext(shipBean);
        shipBean.create(shipCc);
        assert (false);
    }

    @Test(expectedExceptions={CreationException.class})
    @SpecAssertions(value={@SpecAssertion(section="contextual", id="aa")})
    public void testCreateWrapsCheckedExceptionAndRethrows() {
        Bean<Lorry> lorryBean = this.getBeans(Lorry.class, new Annotation[]{this.FAIL_LITERAL}).iterator().next();
        CreationalContext lorryCc = this.getCurrentManager().createCreationalContext(lorryBean);
        lorryBean.create(lorryCc);
        assert (false);
    }
}

