/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.lang.reflect.Modifier;
import org.jboss.cdi.lang.model.tck.PlainClassMembers;

public interface InterfaceMembers {
    public static final String publicStaticFinalField = "";
    public static final String publicStaticField = "";
    public static final String publicFinalField = "";
    public static final String publicField = "";
    public static final String staticFinalField = "";
    public static final String staticField = "";
    public static final String finalField = "";
    public static final String field = "";

    public static void publicStaticMethod() {
    }

    public static void staticMethod() {
    }

    private static void privateStaticMethod() {
    }

    public void publicAbstractMethod();

    public void abstractMethod();

    default public void publicDefaultMethod() {
    }

    default public void defaultMethod() {
    }

    private void privateMethod() {
    }

    public static class Verifier {
        public static void verify(ClassInfo clazz) {
            assert (clazz.name().equals("org.jboss.cdi.lang.model.tck.InterfaceMembers"));
            assert (clazz.simpleName().equals("InterfaceMembers"));
            assert (!clazz.isPlainClass());
            assert (clazz.isInterface());
            assert (!clazz.isEnum());
            assert (!clazz.isAnnotation());
            assert (!clazz.isRecord());
            assert (clazz.isAbstract());
            assert (!clazz.isFinal());
            assert (Modifier.isPublic(clazz.modifiers()));
            assert (!Modifier.isProtected(clazz.modifiers()));
            assert (!Modifier.isPrivate(clazz.modifiers()));
            Verifier.verifyFields(clazz);
            Verifier.verifyMethods(clazz);
            assert (clazz.constructors().isEmpty());
        }

        private static void verifyFields(ClassInfo clazz) {
            assert (clazz.fields().size() == 8);
            PlainClassMembers.Verifier.assertField(clazz, "publicStaticFinalField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "publicStaticField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "publicFinalField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "publicField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "staticFinalField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "staticField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "finalField", 1, true, true, true);
            PlainClassMembers.Verifier.assertField(clazz, "field", 1, true, true, true);
        }

        private static void verifyMethods(ClassInfo clazz) {
            assert (clazz.methods().size() == 8);
            PlainClassMembers.Verifier.assertMethod(clazz, "publicStaticMethod", 1, true, false, false);
            PlainClassMembers.Verifier.assertMethod(clazz, "staticMethod", 1, true, false, false);
            PlainClassMembers.Verifier.assertMethod(clazz, "privateStaticMethod", 2, true, false, false);
            PlainClassMembers.Verifier.assertMethod(clazz, "publicAbstractMethod", 1, false, false, true);
            PlainClassMembers.Verifier.assertMethod(clazz, "abstractMethod", 1, false, false, true);
            PlainClassMembers.Verifier.assertMethod(clazz, "publicDefaultMethod", 1, false, false, false);
            PlainClassMembers.Verifier.assertMethod(clazz, "defaultMethod", 1, false, false, false);
            PlainClassMembers.Verifier.assertMethod(clazz, "privateMethod", 2, false, false, false);
        }
    }
}

