/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.alternative.selection.priority;

import jakarta.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.alternative.selection.priority.Alpha;
import org.jboss.cdi.tck.tests.alternative.selection.priority.Beta;
import org.jboss.cdi.tck.tests.alternative.selection.priority.Delta;
import org.jboss.cdi.tck.tests.alternative.selection.priority.Gamma;
import org.jboss.cdi.tck.tests.alternative.selection.priority.ProducedByField;
import org.jboss.cdi.tck.tests.alternative.selection.priority.ProducedByMethod;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class ProducerExplicitPriorityTest
extends AbstractTest {
    public static final String DEFAULT = "default";
    public static final String ALT = "alternative";
    public static final String ALT2 = "alternative2";
    @Inject
    @ProducedByMethod
    Alpha alphaMethodProducer;
    @Inject
    @ProducedByField
    Alpha alphaFieldProducer;
    @Inject
    @ProducedByMethod
    Beta betaMethodProducer;
    @Inject
    @ProducedByField
    Beta betaFieldProducer;
    @Inject
    @ProducedByMethod
    Gamma gammaMethodProducer;
    @Inject
    @ProducedByField
    Gamma gammaFieldProducer;
    @Inject
    @ProducedByMethod
    Delta deltaMethodProducer;
    @Inject
    @ProducedByField
    Delta deltaFieldProducer;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerExplicitPriorityTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_selected_alternatives_application", id="ca"), @SpecAssertion(section="declaring_selected_alternatives_application", id="cb")})
    public void testAlternativeProducerWithPriority() {
        Assert.assertNotNull((Object)this.alphaMethodProducer);
        Assert.assertNotNull((Object)this.alphaFieldProducer);
        Assert.assertEquals((String)this.alphaMethodProducer.ping(), (String)ALT);
        Assert.assertEquals((String)this.alphaFieldProducer.ping(), (String)ALT);
    }

    @Test
    @SpecAssertion(section="declaring_selected_alternatives_application", id="dd")
    public void testPriorityOnProducerOverPriorityOnClass() {
        Assert.assertNotNull((Object)this.betaMethodProducer);
        Assert.assertNotNull((Object)this.betaFieldProducer);
        Assert.assertNotNull((Object)this.gammaFieldProducer);
        Assert.assertNotNull((Object)this.gammaMethodProducer);
        Assert.assertNotNull((Object)this.deltaFieldProducer);
        Assert.assertNotNull((Object)this.deltaMethodProducer);
        Assert.assertEquals((String)this.betaMethodProducer.ping(), (String)ALT2);
        Assert.assertEquals((String)this.betaFieldProducer.ping(), (String)ALT2);
        Assert.assertEquals((String)this.gammaFieldProducer.ping(), (String)ALT2);
        Assert.assertEquals((String)this.gammaMethodProducer.ping(), (String)ALT2);
        Assert.assertEquals((String)this.deltaFieldProducer.ping(), (String)ALT2);
        Assert.assertEquals((String)this.deltaMethodProducer.ping(), (String)ALT2);
    }
}

