/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.context;

import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.context.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.full.context.MyContextual;
import org.jboss.cdi.tck.tests.full.context.MySessionBean;
import org.jboss.cdi.tck.tests.full.context.SimpleBeanA;
import org.jboss.cdi.tck.tests.full.context.SimpleBeanB;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class NormalContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NormalContextTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL))).withExtension(AfterBeanDiscoveryObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="context", id="j"), @SpecAssertion(section="context", id="l"), @SpecAssertion(section="normal_scope", id="c")})
    public void testGetReturnsExistingInstance() {
        Bean<MySessionBean> mySessionBean = this.getBeans(MySessionBean.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(mySessionBean);
        MySessionBean first = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, creationalContext);
        first.setId(10);
        MySessionBean second = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, creationalContext);
        assert (second.getId() == 10);
        MySessionBean third = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get(mySessionBean);
        assert (third.getId() == 10);
        MySessionBean fourth = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, this.getCurrentManager().createCreationalContext(mySessionBean));
        assert (fourth.getId() == 10);
    }

    @Test
    @SpecAssertion(section="context", id="l")
    public void testGetWithCreationalContextReturnsNewInstance() {
        MyContextual bean = AfterBeanDiscoveryObserver.getBean();
        bean.setShouldReturnNullInstances(false);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext((Contextual)bean);
        MySessionBean newBean = (MySessionBean)this.getCurrentManager().getContext(SessionScoped.class).get((Contextual)bean, creationalContext);
        assert (newBean != null);
        assert (bean.isCreateCalled());
    }

    @Test
    @SpecAssertion(section="context", id="nb")
    public void testGetMayNotReturnNullUnlessContextualCreateReturnsNull() {
        MyContextual bean = AfterBeanDiscoveryObserver.getBean();
        bean.setShouldReturnNullInstances(true);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext((Contextual)bean);
        assert (this.getCurrentManager().getContext(SessionScoped.class).get((Contextual)bean, creationalContext) == null);
        assert (bean.isCreateCalled());
    }

    @Test
    @SpecAssertion(section="normal_scope", id="e")
    public void testSameNormalScopeBeanInjectedEverywhere() {
        SimpleBeanA instanceOfA = this.getContextualReference(SimpleBeanA.class, new Annotation[0]);
        SimpleBeanB instanceOfB = this.getContextualReference(SimpleBeanB.class, new Annotation[0]);
        instanceOfA.getZ().setName("Ben");
        assert (instanceOfA.getZ().getName().equals("Ben"));
        assert (instanceOfB.getZ().getName().equals("Ben"));
    }
}

