/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.invokers;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.invoke.Invoker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="4.1")
public class SimpleInvokerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(SimpleInvokerTest.class)).withClasses(MyService.class)).withExtension(TestExtension.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="method_invokers_full", id="a")
    public void test(MyService service) throws Exception {
        Invoker hello = ((TestExtension)this.getCurrentManager().getExtension(TestExtension.class)).getInvoker("hello");
        Assert.assertEquals((String)((String)hello.invoke((Object)service, new Object[]{1, List.of()})), (String)"foobar1[]");
    }

    @ApplicationScoped
    public static class MyService {
        public String hello(int param1, List<String> param2) {
            return "foobar" + param1 + param2;
        }
    }

    public static class TestExtension
    implements Extension {
        private Map<String, Invoker<?, ?>> invokers = new HashMap();

        public void myServiceRegistration(@Observes ProcessManagedBean<MyService> pmb) {
            pmb.getAnnotatedBeanClass().getMethods().stream().filter(it -> "hello".equals(it.getJavaMember().getName())).forEach(it -> this.invokers.put(it.getJavaMember().getName(), (Invoker)pmb.createInvoker(it).build()));
        }

        public <T, R> Invoker<T, R> getInvoker(String name) {
            return this.invokers.get(name);
        }
    }
}

