/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.inheritedapi;

import ee.jakarta.tck.concurrent.common.CommonTasks;
import ee.jakarta.tck.concurrent.common.counter.CounterInterface;
import ee.jakarta.tck.concurrent.common.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.framework.EJBJNDIProvider;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.inheritedapi.TestEjbInterface;
import jakarta.ejb.EJB;
import jakarta.ejb.Stateless;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.testng.Assert;

@Stateless
public class TestEjb
implements TestEjbInterface {
    @EJB
    private CounterInterface counter;

    @Override
    public void testApiSubmit() {
        try {
            Future result = TestUtil.getManagedScheduledExecutorService().submit((Callable)new CommonTasks.SimpleCallable());
            TestUtil.waitTillFutureIsDone(result);
            Assert.assertEquals(result.get(), (Object)"ok");
            result = TestUtil.getManagedScheduledExecutorService().submit((Runnable)new CommonTasks.SimpleRunnable());
            TestUtil.waitTillFutureIsDone(result);
            result.get();
            result = TestUtil.getManagedScheduledExecutorService().submit((Runnable)new CommonTasks.SimpleRunnable(), (Object)"ok");
            TestUtil.waitTillFutureIsDone(result);
            Assert.assertEquals(result.get(), (Object)"ok");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void testApiExecute() {
        try {
            EJBJNDIProvider nameProvider = ServiceLoader.load(EJBJNDIProvider.class).findFirst().orElseThrow();
            TestUtil.getManagedScheduledExecutorService().execute((Runnable)new CounterRunnableTask(nameProvider.getEJBJNDIName()));
            this.waitForCounter(1);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            this.counter.reset();
        }
    }

    @Override
    public void testApiInvokeAll() {
        List resultList;
        ArrayList<Callable> taskList;
        try {
            taskList = new ArrayList<Callable>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            resultList = TestUtil.getManagedScheduledExecutorService().invokeAll(taskList);
            for (Future each : resultList) {
                TestUtil.waitTillFutureIsDone(each);
            }
            Assert.assertEquals(((Future)resultList.get(0)).get(), (Object)1);
            Assert.assertEquals(((Future)resultList.get(1)).get(), (Object)2);
            Assert.assertEquals(((Future)resultList.get(2)).get(), (Object)3);
            resultList = TestUtil.getManagedScheduledExecutorService().invokeAll(taskList, TestConstants.WaitTimeout.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                TestUtil.waitTillFutureIsDone(each);
            }
            Assert.assertEquals(((Future)resultList.get(0)).get(), (Object)1);
            Assert.assertEquals(((Future)resultList.get(1)).get(), (Object)2);
            Assert.assertEquals(((Future)resultList.get(2)).get(), (Object)3);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.WaitTimeout.toMillis()));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.WaitTimeout.toMillis()));
            resultList = TestUtil.getManagedScheduledExecutorService().invokeAll(taskList, TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                TestUtil.waitTillFutureThrowsException(each, CancellationException.class);
            }
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Override
    public void testApiInvokeAny() {
        ArrayList<Callable> taskList;
        try {
            taskList = new ArrayList<Callable>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            Object result = TestUtil.getManagedScheduledExecutorService().invokeAny(taskList);
            TestUtil.assertInRange(new Integer[]{1, 2, 3}, result);
            result = TestUtil.getManagedScheduledExecutorService().invokeAny(taskList, TestConstants.WaitTimeout.getSeconds(), TimeUnit.SECONDS);
            TestUtil.assertInRange(new Integer[]{1, 2, 3}, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.WaitTimeout.toMillis()));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.WaitTimeout.toMillis()));
            Object object = TestUtil.getManagedScheduledExecutorService().invokeAny(taskList, TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return;
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
        Assert.fail((String)"Task should be cancelled because of timeout");
    }

    @Override
    public void testApiSchedule() {
        try {
            ScheduledFuture result = TestUtil.getManagedScheduledExecutorService().schedule((Callable)new CommonTasks.SimpleCallable(), TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
            TestUtil.waitTillFutureIsDone(result);
            Assert.assertEquals((Object)"ok", result.get());
            result = TestUtil.getManagedScheduledExecutorService().schedule((Runnable)new CommonTasks.SimpleRunnable(), TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
            TestUtil.waitTillFutureIsDone(result);
            Assert.assertEquals(result.get(), null);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Override
    public void testApiScheduleAtFixedRate() {
        Future result = null;
        try {
            EJBJNDIProvider nameProvider = ServiceLoader.load(EJBJNDIProvider.class).findFirst().orElseThrow();
            result = TestUtil.getManagedScheduledExecutorService().scheduleAtFixedRate((Runnable)new CounterRunnableTask(nameProvider.getEJBJNDIName()), TestConstants.PollInterval.getSeconds(), TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
            TestUtil.sleep(TestConstants.WaitTimeout);
            TestUtil.assertIntInRange(TestConstants.PollsPerTimeout - 2, TestConstants.PollsPerTimeout + 2, this.counter.getCount());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (result != null) {
                result.cancel(true);
                try {
                    TestUtil.sleep(TestConstants.PollInterval);
                }
                catch (Exception exception) {}
            }
            this.counter.reset();
        }
    }

    @Override
    public void testApiScheduleWithFixedDelay() {
        Future result = null;
        try {
            EJBJNDIProvider nameProvider = ServiceLoader.load(EJBJNDIProvider.class).findFirst().orElseThrow();
            result = TestUtil.getManagedScheduledExecutorService().scheduleWithFixedDelay((Runnable)new CounterRunnableTask(nameProvider.getEJBJNDIName(), TestConstants.PollInterval.toMillis()), TestConstants.PollInterval.getSeconds(), TestConstants.PollInterval.getSeconds(), TimeUnit.SECONDS);
            TestUtil.sleep(TestConstants.WaitTimeout);
            TestUtil.assertIntInRange(TestConstants.PollsPerTimeout / 2 - 2, TestConstants.PollsPerTimeout / 2 + 2, this.counter.getCount());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (result != null) {
                result.cancel(true);
                try {
                    TestUtil.sleep(TestConstants.PollInterval);
                }
                catch (Exception exception) {}
            }
            this.counter.reset();
        }
    }

    private void waitForCounter(int expected) {
        long start = System.currentTimeMillis();
        while (expected != this.counter.getCount()) {
            try {
                TestUtil.sleep(TestConstants.PollInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= TestConstants.WaitTimeout.toMillis()) continue;
            throw new RuntimeException("Static counter did not produce expected counter before timeout. Expected: " + expected + " Actual: " + this.counter.getCount());
        }
    }
}

