/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.signature;

import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.signature.ConcurrencySigTest;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import org.testng.Assert;

@WebServlet(value={"/SignatureTestServlet"})
public class SignatureTestServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final TestLogger log = TestLogger.get(SignatureTestServlet.class);

    public void testSignatures(HttpServletRequest req, HttpServletResponse resp) throws Throwable {
        Method[] mm;
        Assert.assertNotNull((Object)System.getProperty("jimage.dir"), (String)"The system property jimage.dir must be set in order to run the Signature test.");
        int javaSpecVersion = Integer.parseInt(System.getProperty("java.specification.version"));
        Assert.assertTrue((javaSpecVersion >= 11 ? 1 : 0) != 0, (String)"The signature tests must be run on an application server using Java 11 or higher.");
        Class<?> intf = Class.forName("jdk.internal.vm.annotation.Contended");
        for (Method m : mm = intf.getDeclaredMethods()) {
            String message;
            try {
                m.setAccessible(true);
            }
            catch (InaccessibleObjectException ioe) {
                message = "Tried to call setAccessible on JDK internal method and received an InaccessibleObjectException from the JDK. Give this application (module) access to internal messages using the following JVM properties: --add-exports java.base/jdk.internal.vm.annotation=ALL-UNNAMED --add-opens java.base/jdk.internal.vm.annotation=ALL-UNNAMED";
                Assert.fail((String)message);
            }
            catch (SecurityException se) {
                message = "Tried to call setAccessible on JDK internal method and received SecurityException from the security manager. Give this application permission to make this method call with the security manager using the following permissions:permission java.lang.RuntimePermission \"accessClassInPackage.jdk.internal\"; permission java.lang.RuntimePermission \"accessClassInPackage.jdk.internal.reflect\"; permission java.lang.RuntimePermission \"accessClassInPackage.jdk.internal.vm.annotation\";";
                Assert.fail((String)message);
            }
        }
        ConcurrencySigTest sigTest = new ConcurrencySigTest();
        sigTest.signatureTest();
    }
}

