/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.coreprofile.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestNGMethod;

public class SuiteLogger
implements ISuiteListener {
    private static final Logger logger = Logger.getLogger(SuiteLogger.class.getName());
    private static final String CONFIGURATION_FILE_PATH = "target/cdi-lite-tck-info.log";

    public void onStart(ISuite suite) {
        try {
            FileHandler fh = new FileHandler(CONFIGURATION_FILE_PATH);
            fh.setFormatter(new SimpleFormatter());
            logger.addHandler(fh);
            logger.info("Logging suite tests to file: target/cdi-lite-tck-info.log");
        }
        catch (Exception e) {
            logger.warning("Failed to create file handler for path: target/cdi-lite-tck-info.log");
            e.printStackTrace();
        }
        Collection exluded = suite.getExcludedMethods();
        StringBuilder msg = new StringBuilder();
        for (ITestNGMethod method : exluded) {
            msg.append(method.getTestClass().getName());
            msg.append('#');
            msg.append(method.getMethodName());
            msg.append('\n');
        }
        logger.log(Level.INFO, "+++ Excluded Methods({0}): {1}", new Object[]{exluded.size(), msg});
        List allMethods = suite.getAllMethods();
        msg.setLength(0);
        for (ITestNGMethod method : allMethods) {
            msg.append(method.getTestClass().getName());
            msg.append('#');
            msg.append(method.getMethodName());
            String[] groups = method.getGroups();
            if (groups != null && groups.length > 0) {
                msg.append(";groups=");
                msg.append(Arrays.asList(groups));
            }
            msg.append('\n');
        }
        logger.log(Level.INFO, "+++ All Methods({0}): {1}", new Object[]{allMethods.size(), msg});
    }
}

