/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.core.rest.context.app;

import ee.jakarta.tck.core.rest.JaxRsActivator;
import ee.jakarta.tck.core.rest.context.app.ApplicationResource;
import ee.jakarta.tck.core.rest.context.app.SimpleApplicationBean;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import java.io.File;
import java.net.URI;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestReporter;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class ApplicationContextIT {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ApplicationContextIT.class.getSimpleName() + ".war"));
        ((WebArchive)((WebArchive)archive.addClass(SimpleApplicationBean.class)).addClass(ApplicationResource.class)).addClass(JaxRsActivator.class);
        System.out.printf("test archive: %s\n", archive.toString(true));
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File("/tmp/" + archive.getName()), true);
        return archive;
    }

    @Test
    public void testApplicationContextSharedBetweenJaxRsRequests(TestReporter reporter) throws Exception {
        URI appIdURI = this.contextPath.toURI().resolve("rest/application-id");
        reporter.publishEntry(String.format("appIdURI: %s", appIdURI.toASCIIString()));
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(appIdURI);
        String request1 = (String)target.request(new String[]{"application/json", "text/plain"}).get(String.class);
        String request2 = (String)target.request(new String[]{"application/json", "text/plain"}).get(String.class);
        Assertions.assertEquals((double)Double.parseDouble(request1), (double)Double.parseDouble(request2));
    }
}

