/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import jdk.incubator.http.AsyncConnection;
import jdk.incubator.http.AsyncEvent;
import jdk.incubator.http.ConnectionPool;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.internal.common.AsyncWriteQueue;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Utils;

class PlainHttpConnection
extends HttpConnection
implements AsyncConnection {
    protected final SocketChannel chan;
    private volatile boolean connected;
    private boolean closed;
    private volatile Consumer<ByteBufferReference> asyncReceiver;
    private volatile Consumer<Throwable> errorReceiver;
    private volatile Supplier<ByteBufferReference> readBufferSupplier;
    private boolean asyncReading;
    private final AsyncWriteQueue asyncOutputQ = new AsyncWriteQueue(this::asyncOutput);
    private final Object reading = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReading() {
        try {
            Object object = this.reading;
            synchronized (object) {
                this.asyncReading = true;
            }
            this.client.registerEvent(new ReadEvent());
        }
        catch (IOException iOException) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAsyncReading() {
        Object object = this.reading;
        synchronized (object) {
            this.asyncReading = false;
        }
        this.client.cancelRegistration(this.chan);
    }

    @Override
    public CompletableFuture<Void> connectAsync() {
        MinimalFuture<Void> minimalFuture = new MinimalFuture<Void>();
        try {
            this.chan.configureBlocking(false);
            this.chan.connect(this.address);
            this.client.registerEvent(new ConnectEvent(minimalFuture));
        }
        catch (IOException iOException) {
            minimalFuture.completeExceptionally(iOException);
        }
        return minimalFuture;
    }

    @Override
    public void connect() throws IOException {
        this.chan.connect(this.address);
        this.connected = true;
    }

    @Override
    SocketChannel channel() {
        return this.chan;
    }

    PlainHttpConnection(InetSocketAddress inetSocketAddress, HttpClientImpl httpClientImpl) {
        super(inetSocketAddress, httpClientImpl);
        try {
            this.chan = SocketChannel.open();
            int n = httpClientImpl.getReceiveBufferSize();
            this.chan.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)n);
            this.chan.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException);
        }
    }

    @Override
    long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (this.getMode() != HttpConnection.Mode.ASYNC) {
            return this.chan.write(byteBufferArray, n, n2);
        }
        byteBufferArray = Utils.reduce(byteBufferArray, n, n2);
        long l = Utils.remaining(byteBufferArray);
        this.asyncOutputQ.put(ByteBufferReference.toReferences(byteBufferArray));
        this.flushAsync();
        return l;
    }

    @Override
    long write(ByteBuffer byteBuffer) throws IOException {
        if (this.getMode() != HttpConnection.Mode.ASYNC) {
            return this.chan.write(byteBuffer);
        }
        long l = byteBuffer.remaining();
        this.asyncOutputQ.put(ByteBufferReference.toReferences(byteBuffer));
        this.flushAsync();
        return l;
    }

    void flushRegistered() {
        if (this.getMode() == HttpConnection.Mode.ASYNC) {
            try {
                this.asyncOutputQ.flushDelayed();
            }
            catch (IOException iOException) {
                this.shutdown();
            }
        }
    }

    @Override
    public void writeAsync(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        if (this.getMode() != HttpConnection.Mode.ASYNC) {
            this.chan.write(ByteBufferReference.toBuffers(byteBufferReferenceArray));
            ByteBufferReference.clear(byteBufferReferenceArray);
        } else {
            this.asyncOutputQ.put(byteBufferReferenceArray);
        }
    }

    @Override
    public void writeAsyncUnordered(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        if (this.getMode() != HttpConnection.Mode.ASYNC) {
            this.chan.write(ByteBufferReference.toBuffers(byteBufferReferenceArray));
            ByteBufferReference.clear(byteBufferReferenceArray);
        } else {
            this.asyncOutputQ.putFirst(byteBufferReferenceArray);
        }
    }

    @Override
    public void flushAsync() throws IOException {
        if (this.getMode() == HttpConnection.Mode.ASYNC) {
            this.asyncOutputQ.flush();
        }
    }

    @Override
    public void enableCallback() {
        assert (false);
    }

    void asyncOutput(ByteBufferReference[] byteBufferReferenceArray, AsyncWriteQueue asyncWriteQueue) {
        try {
            ByteBuffer[] byteBufferArray = ByteBufferReference.toBuffers(byteBufferReferenceArray);
            while (Utils.remaining(byteBufferArray) > 0) {
                long l = this.chan.write(byteBufferArray);
                if (l != 0L) continue;
                asyncWriteQueue.setDelayed(byteBufferReferenceArray);
                this.client.registerEvent(new WriteEvent());
                return;
            }
            ByteBufferReference.clear(byteBufferReferenceArray);
        }
        catch (IOException iOException) {
            this.shutdown();
        }
    }

    @Override
    public String toString() {
        return "PlainHttpConnection: " + super.toString();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            Log.logError("Closing: " + this.toString(), new Object[0]);
            this.chan.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    void shutdownInput() throws IOException {
        this.chan.shutdownInput();
    }

    @Override
    void shutdownOutput() throws IOException {
        this.chan.shutdownOutput();
    }

    void shutdown() {
        this.close();
        this.errorReceiver.accept(new IOException("Connection aborted"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncRead() {
        Object object = this.reading;
        synchronized (object) {
            try {
                while (this.asyncReading) {
                    ByteBufferReference byteBufferReference = this.readBufferSupplier.get();
                    int n = this.chan.read(byteBufferReference.get());
                    if (n == -1) {
                        throw new IOException();
                    }
                    if (n == 0) {
                        byteBufferReference.clear();
                        return;
                    }
                    byteBufferReference.get().flip();
                    this.asyncReceiver.accept(byteBufferReference);
                }
            }
            catch (IOException iOException) {
                this.shutdown();
            }
        }
    }

    @Override
    protected ByteBuffer readImpl() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        int n = this.readImpl(byteBuffer);
        if (n > 0) {
            return byteBuffer;
        }
        if (n == 0) {
            return Utils.EMPTY_BYTEBUFFER;
        }
        return null;
    }

    private int readImpl(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.position();
        int n2 = this.chan.read(byteBuffer);
        if (n2 == -1) {
            return -1;
        }
        Utils.flipToMark(byteBuffer, n);
        return n2;
    }

    @Override
    ConnectionPool.CacheKey cacheKey() {
        return new ConnectionPool.CacheKey(this.address, null);
    }

    @Override
    synchronized boolean connected() {
        return this.connected;
    }

    @Override
    boolean isSecure() {
        return false;
    }

    @Override
    boolean isProxied() {
        return false;
    }

    @Override
    public void setAsyncCallbacks(Consumer<ByteBufferReference> consumer, Consumer<Throwable> consumer2, Supplier<ByteBufferReference> supplier) {
        this.asyncReceiver = consumer;
        this.errorReceiver = consumer2;
        this.readBufferSupplier = supplier;
    }

    @Override
    CompletableFuture<Void> whenReceivingResponse() {
        MinimalFuture<Void> minimalFuture = new MinimalFuture<Void>();
        try {
            ReceiveResponseEvent receiveResponseEvent = new ReceiveResponseEvent(minimalFuture);
            this.client.registerEvent(receiveResponseEvent);
        }
        catch (IOException iOException) {
            minimalFuture.completeExceptionally(iOException);
        }
        return minimalFuture;
    }

    class ReceiveResponseEvent
    extends AsyncEvent {
        CompletableFuture<Void> cf;

        ReceiveResponseEvent(CompletableFuture<Void> completableFuture) {
            super(1);
            this.cf = completableFuture;
        }

        @Override
        public SelectableChannel channel() {
            return PlainHttpConnection.this.chan;
        }

        @Override
        public void handle() {
            this.cf.complete(null);
        }

        @Override
        public int interestOps() {
            return 1;
        }

        @Override
        public void abort() {
            PlainHttpConnection.this.close();
        }

        public String toString() {
            return super.toString() + "/" + PlainHttpConnection.this.chan;
        }
    }

    class ReadEvent
    extends AsyncEvent {
        ReadEvent() {
            super(2);
        }

        @Override
        public SelectableChannel channel() {
            return PlainHttpConnection.this.chan;
        }

        @Override
        public int interestOps() {
            return 1;
        }

        @Override
        public void handle() {
            PlainHttpConnection.this.asyncRead();
        }

        @Override
        public void abort() {
            PlainHttpConnection.this.shutdown();
        }

        public String toString() {
            return super.toString() + "/" + PlainHttpConnection.this.chan;
        }
    }

    class WriteEvent
    extends AsyncEvent {
        WriteEvent() {
            super(0);
        }

        @Override
        public SelectableChannel channel() {
            return PlainHttpConnection.this.chan;
        }

        @Override
        public int interestOps() {
            return 4;
        }

        @Override
        public void handle() {
            PlainHttpConnection.this.flushRegistered();
        }

        @Override
        public void abort() {
            PlainHttpConnection.this.shutdown();
        }
    }

    class ConnectEvent
    extends AsyncEvent {
        CompletableFuture<Void> cf;

        ConnectEvent(CompletableFuture<Void> completableFuture) {
            super(1);
            this.cf = completableFuture;
        }

        @Override
        public SelectableChannel channel() {
            return PlainHttpConnection.this.chan;
        }

        @Override
        public int interestOps() {
            return 8;
        }

        @Override
        public void handle() {
            try {
                PlainHttpConnection.this.chan.finishConnect();
            }
            catch (IOException iOException) {
                this.cf.completeExceptionally(iOException);
                return;
            }
            PlainHttpConnection.this.connected = true;
            this.cf.complete(null);
        }

        @Override
        public void abort() {
            PlainHttpConnection.this.close();
        }
    }
}

