/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import java.util.Arrays;
import jdk.incubator.http.internal.hpack.Huffman;
import jdk.incubator.http.internal.hpack.ISO_8859_1;
import jdk.incubator.http.internal.hpack.IntegerWriter;

final class StringWriter {
    private static final int NEW = 0;
    private static final int CONFIGURED = 1;
    private static final int LENGTH_WRITTEN = 2;
    private static final int DONE = 4;
    private final IntegerWriter intWriter = new IntegerWriter();
    private final Huffman.Writer huffmanWriter = new Huffman.Writer();
    private final ISO_8859_1.Writer plainWriter = new ISO_8859_1.Writer();
    private int state = 0;
    private boolean huffman;

    StringWriter() {
    }

    StringWriter configure(CharSequence charSequence, boolean bl) {
        return this.configure(charSequence, 0, charSequence.length(), bl);
    }

    StringWriter configure(CharSequence charSequence, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n2 > charSequence.length() || n > n2) {
            throw new IndexOutOfBoundsException(String.format("input.length()=%s, start=%s, end=%s", charSequence.length(), n, n2));
        }
        if (!bl) {
            this.plainWriter.configure(charSequence, n, n2);
            this.intWriter.configure(n2 - n, 7, 0);
        } else {
            this.huffmanWriter.from(charSequence, n, n2);
            this.intWriter.configure(Huffman.INSTANCE.lengthOf(charSequence, n, n2), 7, 128);
        }
        this.huffman = bl;
        this.state = 1;
        return this;
    }

    boolean write(ByteBuffer byteBuffer) {
        if (this.state == 4) {
            return true;
        }
        if (this.state == 0) {
            throw new IllegalStateException("Configure first");
        }
        if (!byteBuffer.hasRemaining()) {
            return false;
        }
        if (this.state == 1) {
            if (this.intWriter.write(byteBuffer)) {
                this.state = 2;
            } else {
                return false;
            }
        }
        if (this.state == 2) {
            boolean bl;
            boolean bl2 = bl = this.huffman ? this.huffmanWriter.write(byteBuffer) : this.plainWriter.write(byteBuffer);
            if (bl) {
                this.state = 4;
                return true;
            }
            return false;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.huffman}));
    }

    void reset() {
        this.intWriter.reset();
        if (this.huffman) {
            this.huffmanWriter.reset();
        } else {
            this.plainWriter.reset();
        }
        this.state = 0;
    }
}

