/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ELTestUtil {
    private static final System.Logger logger = System.getLogger(ELTestUtil.class.getName());
    public static final String NL = System.getProperty("line.separator", "\n");
    public static final String PASS = "Test PASSED";
    public static final String FAIL = "Test FAILED";

    private ELTestUtil() {
        throw new IllegalStateException();
    }

    public static void checkForNPE(String className, String methName, Class<?>[] argTypes, Object[] params) throws Exception {
        try {
            ELTestUtil.checkForNPE(Class.forName(className), methName, argTypes, params);
        }
        catch (ClassNotFoundException cnfe) {
            throw new Exception(FAIL + NL + cnfe.toString());
        }
    }

    public static void checkForNPE(Class<?> clazz, String methName, Class<?>[] argTypes, Object[] params) throws Exception {
        try {
            ELTestUtil.checkForNPE(clazz.newInstance(), methName, argTypes, params);
        }
        catch (Exception e) {
            throw new Exception(FAIL + NL + e.toString());
        }
    }

    public static void checkForNPE(Object object, String methName, Class<?>[] argTypes, Object[] params) throws Exception {
        ELTestUtil.checkForException(object, methName, argTypes, params, new NullPointerException());
    }

    public static void checkForCNFE(Object object, String methName, Class<?>[] argTypes, Object[] params) throws Exception {
        ELTestUtil.checkForException(object, methName, argTypes, params, new ClassNotFoundException());
    }

    public static void checkForNSME(Object object, String methName, Class<?>[] argTypes, Object[] params) throws Exception {
        ELTestUtil.checkForException(object, methName, argTypes, params, new NoSuchMethodException());
    }

    private static void checkForException(Object object, String methName, Class<?>[] argTypes, Object[] params, Object exceptionType) throws Exception {
        StringBuffer buff = new StringBuffer();
        String className = object.getClass().getName();
        String exceptionMess = ELTestUtil.buildMess(exceptionType.getClass().getSimpleName());
        try {
            Method execMeth = object.getClass().getMethod(methName, argTypes);
            execMeth.invoke(object, params);
            buff.append("Test FAILED No Exception thrown!" + NL + "Expected a " + exceptionType.getClass().getSimpleName() + " to be thrown!" + NL + "when testing: " + className + "." + methName);
        }
        catch (InvocationTargetException ite) {
            if (exceptionType.getClass().isInstance(ite.getCause())) {
                logger.log(System.Logger.Level.INFO, PASS);
                return;
            }
            buff.append(exceptionMess + ite.getCause().getClass().getSimpleName() + NL + "When testing: " + className + "." + methName + NL + ite.getCause().toString());
        }
        catch (Throwable t) {
            buff.append(exceptionMess + t.getClass().getSimpleName() + NL + "When testing: " + className + "." + methName + NL + t.toString());
        }
        throw new Exception(FAIL + NL + buff.toString());
    }

    private static String buildMess(String exceptionName) {
        return "Test FAILED Unexpected Exception Thrown!" + NL + "Expected: " + exceptionName + NL + "Received: ";
    }

    public static void printStackTrace(Throwable e) {
        if (e == null) {
            return;
        }
        try {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(sw);
            e.printStackTrace(writer);
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

