/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.conditionaloperator;

import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private final boolean[] deferred = new boolean[]{true, false};

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void elConditionalStringTest() throws Exception {
        this.testConditionals("true", true);
        this.testConditionals("false", false);
    }

    @Test
    public void elConditionalBooleanTest() throws Exception {
        this.testConditionals(true, true);
        this.testConditionals(false, false);
    }

    private void testConditionals(String testVal, boolean expectedResult) throws Exception {
        boolean pass = false;
        NameValuePair[] value = NameValuePair.buildConditionalNameValue(testVal, true, false);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "conditional");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                boolean bl = pass = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue((Boolean)result, expectedResult);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void testConditionals(boolean testVal, boolean expectedResult) throws Exception {
        boolean pass = false;
        NameValuePair[] value = NameValuePair.buildConditionalNameValue(testVal, true, false);
        try {
            for (boolean tf : this.deferred) {
                String expr = ExprEval.buildElExpr(tf, "conditional");
                Object result = ExprEval.evaluateValueExpression(expr, value, Object.class);
                logger.log(System.Logger.Level.TRACE, "result is " + result.toString());
                boolean bl = pass = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue((Boolean)result, expectedResult);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false");
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

