/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.finder;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ChameleonTestFinder
extends TestFinder {
    private static final String[] excludeNames = new String[]{"SCCS", "deleted_files"};
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ChameleonTestFinder.class);
    private File entryFile;
    private Entry[] entries;
    private boolean ignoreCase;
    private Entry currEntry;
    private ClassLoader loader;
    private Map<String, String> excludeList = new HashMap<String, String>();

    public ChameleonTestFinder() {
        String ic = System.getProperty("javatest.chameleon.ignoreCase");
        if (ic != null) {
            this.ignoreCase = ic.equals("true");
        } else {
            String os = System.getProperty("os.name");
            this.ignoreCase = os.startsWith("Windows");
        }
        this.exclude(excludeNames);
    }

    public void exclude(String name) {
        this.excludeList.put(name, name);
    }

    public void exclude(String ... names) {
        for (String name : names) {
            this.excludeList.put(name, name);
        }
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    @Override
    public void init(String[] args, File testSuiteRoot, TestEnvironment env) throws TestFinder.Fault {
        super.init(args, testSuiteRoot, env);
        if (this.entryFile == null) {
            throw new TestFinder.Fault(i18n, "cham.noConfigFile");
        }
        if (!this.entryFile.isAbsolute()) {
            this.entryFile = new File(this.getRootDir(), this.entryFile.getPath());
        }
        this.readEntries(this.entryFile);
    }

    public void readEntries(File file) throws TestFinder.Fault {
        TreeSet<Entry> s = new TreeSet<Entry>((o1, o2) -> {
            int n = o1.compareTo((Entry)o2);
            return -n;
        });
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            int lineNum = 0;
            while ((line = in.readLine()) != null) {
                line = line.trim();
                ++lineNum;
                if (line.startsWith("#") || line.isEmpty()) continue;
                String[] words = StringArray.split(line);
                if (words.length < 2) {
                    throw new TestFinder.Fault(i18n, "cham.missingData", lineNum, line);
                }
                String pattern = words[0];
                String finderClassName = words[1];
                String[] finderArgs = new String[words.length - 2];
                System.arraycopy(words, 2, finderArgs, 0, finderArgs.length);
                Entry e = new Entry(pattern, finderClassName, finderArgs);
                s.add(e);
            }
        }
        catch (FileNotFoundException e) {
            throw new TestFinder.Fault(i18n, "cham.cantFindFile", (Object)file);
        }
        catch (IOException e) {
            throw new TestFinder.Fault(i18n, "cham.ioError", file, e);
        }
        this.entryFile = file;
        this.entries = s.toArray(new Entry[s.size()]);
    }

    @Override
    protected int decodeArg(String[] args, int i) throws TestFinder.Fault {
        if (args[i].equals("-f") && i + 1 < args.length) {
            this.entryFile = new File(args[i + 1]);
            return 2;
        }
        if (args[i].equalsIgnoreCase("-ignoreCase")) {
            this.ignoreCase = true;
            return 1;
        }
        if (args[i].equalsIgnoreCase("-dontIgnoreCase")) {
            this.ignoreCase = false;
            return 1;
        }
        return super.decodeArg(args, i);
    }

    @Override
    protected void scan(File file) {
        if (file.isDirectory()) {
            this.scanDirectory(file);
        } else {
            this.scanFile(file);
        }
    }

    @Override
    public File[] getFiles() {
        if (this.currEntry == null) {
            return super.getFiles();
        }
        if (this.currEntry.finder == null) {
            return new File[0];
        }
        return this.currEntry.finder.getFiles();
    }

    @Override
    public TestDescription[] getTests() {
        if (this.currEntry == null) {
            return super.getTests();
        }
        if (this.currEntry.finder == null) {
            return new TestDescription[0];
        }
        return this.currEntry.finder.getTests();
    }

    private void scanDirectory(File dir) {
        String[] names;
        this.currEntry = null;
        for (String name : names = dir.list()) {
            if (this.excludeList.containsKey(name)) continue;
            this.foundFile(new File(dir, name));
        }
    }

    private void scanFile(File file) {
        for (Entry entry : this.entries) {
            if (!entry.matches(file)) continue;
            this.currEntry = entry;
            this.currEntry.scanFile(file);
            return;
        }
        this.currEntry = null;
    }

    private TestFinder newInstance(Class<? extends TestFinder> c) throws TestFinder.Fault {
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TestFinder.Fault(i18n, "cham.cantCreateClass", c.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new TestFinder.Fault(i18n, "cham.cantAccessClass", c.getName(), e);
        }
    }

    private Class<? extends TestFinder> loadClass(String className) throws TestFinder.Fault {
        try {
            if (this.loader == null) {
                return Class.forName(className).asSubclass(TestFinder.class);
            }
            return this.loader.loadClass(className).asSubclass(TestFinder.class);
        }
        catch (ClassNotFoundException e) {
            throw new TestFinder.Fault(i18n, "cham.cantFindClass", className, e);
        }
        catch (IllegalArgumentException e) {
            throw new TestFinder.Fault(i18n, "cham.badClassName", (Object)className);
        }
    }

    private TestEnvironment getEnv() {
        return this.env;
    }

    private class Entry {
        private String prefix;
        private String suffix;
        private String finderClassName;
        private String[] finderArgs;
        private TestFinder finder;
        private boolean initialized;

        Entry(String pattern, String finderClassName, String ... finderArgs) {
            int star = pattern.indexOf(42);
            if (star == -1) {
                this.prefix = pattern;
                this.suffix = null;
            } else {
                this.prefix = pattern.substring(0, star);
                this.suffix = pattern.substring(star + 1);
            }
            this.prefix = new File(ChameleonTestFinder.this.getRootDir(), this.prefix.replace('/', File.separatorChar)).getPath();
            if (this.suffix != null) {
                this.suffix = this.suffix.replace('/', File.separatorChar);
            }
            this.finderClassName = finderClassName;
            this.finderArgs = finderArgs;
        }

        boolean matches(File file) {
            String p = file.getPath();
            int pLen = p.length();
            int preLen = this.prefix.length();
            if (!p.regionMatches(ChameleonTestFinder.this.ignoreCase, 0, this.prefix, 0, preLen)) {
                return false;
            }
            if (this.suffix != null) {
                int sufLen = this.suffix.length();
                if (sufLen > pLen) {
                    return false;
                }
                return p.regionMatches(ChameleonTestFinder.this.ignoreCase, pLen - sufLen, this.suffix, 0, sufLen);
            }
            return true;
        }

        void scanFile(File file) {
            if (!this.initialized) {
                this.init();
            }
            if (this.finder != null) {
                this.finder.read(file);
            }
        }

        private void init() {
            try {
                if (!this.finderClassName.equals("-")) {
                    this.finder = ChameleonTestFinder.this.newInstance(ChameleonTestFinder.this.loadClass(this.finderClassName));
                    this.finder.init(this.finderArgs, ChameleonTestFinder.this.getRoot(), ChameleonTestFinder.this.getEnv());
                }
            }
            catch (TestFinder.Fault e) {
                ChameleonTestFinder.this.error(i18n, "cham.cantInitClass", e.getMessage());
            }
            finally {
                this.initialized = true;
            }
        }

        int compareTo(Entry other) {
            int bpl;
            Entry a = this;
            Entry b = other;
            int apl = a.prefix.length();
            if (apl < (bpl = b.prefix.length())) {
                return -1;
            }
            if (apl == bpl) {
                int pc = a.prefix.compareTo(b.prefix);
                if (pc != 0) {
                    return pc;
                }
                String as = a.suffix;
                String bs = b.suffix;
                if (as == null && bs == null) {
                    return 0;
                }
                if (as == null) {
                    return -1;
                }
                if (bs == null) {
                    return 1;
                }
                return as.compareTo(bs);
            }
            return 1;
        }
    }
}

