/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.viewengine.base;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import ee.jakarta.tck.mvc.tests.viewengine.base.CustomViewEngine;
import ee.jakarta.tck.mvc.tests.viewengine.base.ViewEngineBaseController;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="2.0")
public class ViewEngineBaseTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(ViewEngineBaseController.class).addClass(CustomViewEngine.class).addView("viewengine/base/view.jsp").addView("viewengine/base/view.xhtml").addView("viewengine/base/view.custom").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="view_engines_introduction", id="jsp-facelets"), @SpecAssertion(section="selection_algorithm", id="models-binding")})
    public void viewEngineJsp() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/viewengine/base/jsp").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered with the JSP view engine!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="view_engines_introduction", id="jsp-facelets"), @SpecAssertion(section="selection_algorithm", id="models-binding")})
    public void viewEngineFacelets() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/viewengine/base/facelets").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered with the Facelets view engine!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="view_engines_introduction", id="cdi-discovery")})
    public void viewEngineCustom() throws IOException {
        WebResponse response = this.webClient.getPage(this.baseUrl.toString() + "mvc/viewengine/base/custom").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered with the Custom view engine!"));
    }
}

