/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlBase.class)
public class HTMLBaseElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public HTMLBaseElement() {
    }

    @JsxGetter
    public String getHref() {
        String href = this.getDomNodeOrDie().getAttributeDirect("href");
        if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLBASE_HREF_DEFAULT_EMPTY)) {
                return href;
            }
            return this.getWindow().getLocation().getHref();
        }
        return href;
    }

    @JsxSetter
    public void setHref(String href) {
        this.getDomNodeOrDie().setAttribute("href", href);
    }

    @JsxGetter
    public String getTarget() {
        return this.getDomNodeOrDie().getAttributeDirect("target");
    }

    @JsxSetter
    public void setTarget(String target) {
        this.getDomNodeOrDie().setAttribute("target", target);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }
}

