/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.basic;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Animal;
import ee.jakarta.tck.nosql.factories.AnimalSupplier;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The basic template operations with inheritance using MappedSuperclass annotation")
public class BasicTemplateMappedSuperclassTest
extends AbstractTemplateTest {
    private static final Logger LOGGER = Logger.getLogger(BasicTemplateMappedSuperclassTest.class.getName());

    @ParameterizedTest
    @ArgumentsSource(value=AnimalSupplier.class)
    @DisplayName(value="Should insert the animal: {0}")
    void shouldInsert(Animal entity) {
        Animal animal = (Animal)this.template.insert((Object)entity);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)animal).isNotNull();
            soft.assertThat(animal.getId()).isNotNull();
            soft.assertThat(animal.getName()).isEqualTo(entity.getName());
            soft.assertThat(animal.getScientificName()).isEqualTo(entity.getScientificName());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalSupplier.class)
    @DisplayName(value="Should update the animal: {0}")
    void shouldUpdate(Animal entity) {
        Animal insertedAnimal = (Animal)this.template.insert((Object)entity);
        insertedAnimal.setSpecies("Updated Species");
        Animal updatedAnimal = (Animal)this.template.update((Object)insertedAnimal);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)updatedAnimal).isNotNull();
            soft.assertThat(updatedAnimal.getId()).isEqualTo(insertedAnimal.getId());
            soft.assertThat(updatedAnimal.getSpecies()).isEqualTo("Updated Species");
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalSupplier.class)
    @DisplayName(value="Should delete the animal: {0}")
    void shouldDelete(Animal entity) {
        Animal insertedAnimal = (Animal)this.template.insert((Object)entity);
        this.template.delete(Animal.class, (Object)insertedAnimal.getId());
        Optional deletedAnimal = this.template.find(Animal.class, (Object)insertedAnimal.getId());
        SoftAssertions.assertSoftly(soft -> soft.assertThat(deletedAnimal).isEmpty());
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalSupplier.class)
    @DisplayName(value="Should find the animal: {0}")
    void shouldFind(Animal entity) {
        Animal insertedAnimal = (Animal)this.template.insert((Object)entity);
        Optional foundAnimal = this.template.find(Animal.class, (Object)insertedAnimal.getId());
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(foundAnimal).isPresent();
            soft.assertThat(((Animal)foundAnimal.orElseThrow()).getId()).isEqualTo(insertedAnimal.getId());
            soft.assertThat(((Animal)foundAnimal.orElseThrow()).getName()).isEqualTo(insertedAnimal.getName());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=AnimalSupplier.class)
    @DisplayName(value="Should insert animal with TTL")
    void shouldInsertWithTTL(Animal animal) {
        try {
            Animal insertedAnimal = (Animal)this.template.insert((Object)animal, Duration.ofMinutes(10L));
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat((Object)insertedAnimal).isNotNull();
                soft.assertThat(insertedAnimal.getId()).isNotNull();
                soft.assertThat(insertedAnimal.getName()).isEqualTo(animal.getName());
            });
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("TTL operation not supported by this database: " + e.getMessage());
        }
    }

    @Test
    @DisplayName(value="Should throw exception when null entity is inserted")
    void shouldThrowExceptionWhenNullEntityInserted() {
        Assertions.assertThatThrownBy(() -> this.template.insert(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    @DisplayName(value="Should throw exception when null entity is updated")
    void shouldThrowExceptionWhenNullEntityUpdated() {
        Assertions.assertThatThrownBy(() -> this.template.update(null)).isInstanceOf(NullPointerException.class);
    }
}

