/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.entities;

import ee.jakarta.tck.nosql.entities.Transmission;
import jakarta.nosql.Column;
import jakarta.nosql.Entity;
import jakarta.nosql.Id;
import java.util.Objects;
import java.util.UUID;
import net.datafaker.Faker;

@Entity
public class Vehicle {
    @Id
    private String id;
    @Column
    private String model;
    @Column
    private String make;
    @Column
    private String manufacturer;
    @Column
    private String color;
    @Column
    private Transmission transmission;

    public String getId() {
        return this.id;
    }

    public String getModel() {
        return this.model;
    }

    public String getMake() {
        return this.make;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getColor() {
        return this.color;
    }

    public Transmission getTransmission() {
        return this.transmission;
    }

    public void setTransmission(Transmission transmission) {
        this.transmission = transmission;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String toString() {
        return "Vehicle{id='" + this.id + "', model='" + this.model + "', make='" + this.make + "', manufacturer='" + this.manufacturer + "', color='" + this.color + "', transmission=" + String.valueOf((Object)this.transmission) + "}";
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vehicle)) {
            return false;
        }
        Vehicle vehicle = (Vehicle)object;
        return Objects.equals(this.id, vehicle.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public static Vehicle of(Faker faker) {
        net.datafaker.providers.base.Vehicle fakeVehicle = faker.vehicle();
        Vehicle vehicle = new Vehicle();
        vehicle.id = UUID.randomUUID().toString();
        vehicle.model = fakeVehicle.model();
        vehicle.make = fakeVehicle.make();
        vehicle.manufacturer = fakeVehicle.manufacturer();
        vehicle.color = fakeVehicle.color();
        vehicle.transmission = faker.number().positive() % 2 == 0 ? Transmission.MANUAL : Transmission.AUTOMATIC;
        return vehicle;
    }
}

