/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.tagfiles.packaging;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setContextRoot("/jsp_tagfile_pkg_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_tagfile_pkg_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_tagfile_pkg_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tag.tld", "tag.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/WebTag1.tag", "tags/WebTag1.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/badtldversion/WebTag1.tag", "tags/badtldversion/WebTag1.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/badtldversion/implicit.tld", "tags/badtldversion/implicit.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/defaultjspversion/WebTag1.tag", "tags/defaultjspversion/WebTag1.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/dir/WebTag1.tag", "tags/dir/WebTag1.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/reservedname20/DeferredSyntaxAsLiteral.tag", "tags/reservedname20/DeferredSyntaxAsLiteral.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/reservedname20/ImplicitTld20.tag", "tags/reservedname20/ImplicitTld20.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/reservedname20/implicit.tld", "tags/reservedname20/implicit.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/reservedname21/DeferredSyntaxAsLiteral.tag", "tags/reservedname21/DeferredSyntaxAsLiteral.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/reservedname21/ImplicitTld21.tag", "tags/reservedname21/ImplicitTld21.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/reservedname21/implicit.tld", "tags/reservedname21/implicit.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/toomanytldelements/WebTag1.tag", "tags/toomanytldelements/WebTag1.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/toomanytldelements/implicit.tld", "tags/toomanytldelements/implicit.tld");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/versionnotmatch/WebTag1.tag", "tags/versionnotmatch/WebTag1.tag");
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/versionnotmatch/implicit.tld", "tags/versionnotmatch/implicit.tld");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/IgnoreTag.tag")), "IgnoreTag.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/Tag1.tag")), "Tag1.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ImplicitTldAdditionalElements.jsp")), "ImplicitTldAdditionalElements.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ImplicitTldDefaultJspVersion.jsp")), "ImplicitTldDefaultJspVersion.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ImplicitTldMinimumJspVersion.jsp")), "ImplicitTldMinimumJspVersion.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ImplicitTldReservedName20.jsp")), "ImplicitTldReservedName20.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/ImplicitTldReservedName21.jsp")), "ImplicitTldReservedName21.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagFilePackagedJarIgnoredTagTest.jsp")), "JspTagFilePackagedJarIgnoredTagTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagFilePackagedJarTest.jsp")), "JspTagFilePackagedJarTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagFilePackagedWarTest.jsp")), "JspTagFilePackagedWarTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/JspTagFilePackagedWarTldTest.jsp")), "JspTagFilePackagedWarTldTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/TldImplicitTldJspVersionNotMatch.jsp")), "TldImplicitTldJspVersionNotMatch.jsp");
        JavaArchive tagfileJar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"tagfile.jar");
        tagfileJar.addAsResource((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/jartagfile.tld")), "META-INF/jartagfile.tld");
        tagfileJar.addAsResource((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/IgnoreTag.tag")), "META-INF/tags/IgnoreTag.tag");
        tagfileJar.addAsResource((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/Tag1.tag")), "META-INF/tags/Tag1.tag");
        archive.addAsLibrary((Archive)tagfileJar);
        return archive;
    }

    @Test
    public void jspTagFilePackagedJarTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/JspTagFilePackagedJarTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void jspTagFilePackagedJarIgnoredTagTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/JspTagFilePackagedJarIgnoredTagTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspTagFilePackagedWarTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/JspTagFilePackagedWarTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED1|Test PASSED2");
        this.invoke();
    }

    @Test
    public void jspTagFilePackagedWarTldTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/JspTagFilePackagedWarTldTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED1");
        this.invoke();
    }

    @Test
    public void implicitTldMinimumJspVersionTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/ImplicitTldMinimumJspVersion.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void implicitTldAdditionalElementsTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/ImplicitTldAdditionalElements.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void tldImplicitTldJspVersionNotMatchTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/TldImplicitTldJspVersionNotMatch.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void implicitTldReservedName20Test() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/ImplicitTldReservedName20.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void implicitTldReservedName21Test() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/ImplicitTldReservedName21.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void implicitTldDefaultJspVersionTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_tagfile_pkg_web/ImplicitTldDefaultJspVersion.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }
}

