/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkey;

import ee.jakarta.tck.persistence.core.annotations.mapkey.Client;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Employee;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends Client {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Department", pkgName + "Employee", pkgName + "Employee2", pkgName + "Employee3", pkgName + "Employee4"};
        return this.createDeploymentJar("jpa_core_annotations_mapkey1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupCreateTestData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMapKeyTest1() throws Exception {
        boolean pass = true;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            expected.add(this.empRef[0].getId());
            expected.add(this.empRef[2].getId());
            expected.add(this.empRef[4].getId());
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find Employees belonging to Department: Marketing");
            List l = this.getEntityManager().createQuery("Select e from Employee e where e.department.name = 'Marketing'").getResultList();
            for (Object o : l) {
                Employee e = (Employee)o;
                actual.add(e.getId());
            }
            Collections.sort(actual);
            if (expected.equals(actual)) {
                logger.log(System.Logger.Level.TRACE, "Received expected employees");
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected id values were:");
                for (Integer i : expected) {
                    logger.log(System.Logger.Level.ERROR, "id: " + i);
                }
                logger.log(System.Logger.Level.ERROR, "actual id values were:");
                Collections.sort(actual);
                for (Integer i : actual) {
                    logger.log(System.Logger.Level.ERROR, "id: " + i);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)ex);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMapKeyTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void annotationMapKeyTest2() throws Exception {
        boolean pass = true;
        try {
            ArrayList<Integer> expected = new ArrayList<Integer>();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            expected.add(this.empRef[1].getId());
            expected.add(this.empRef[3].getId());
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find Employees belonging to Department: Marketing");
            List l = this.getEntityManager().createQuery("Select e.id from Employee e where e.department.name = 'Administration' ORDER BY e.id DESC").getResultList();
            for (Object o : l) {
                Integer i = (Integer)o;
                actual.add(i);
            }
            Collections.sort(actual);
            if (expected.equals(actual)) {
                logger.log(System.Logger.Level.TRACE, "Received expected employees");
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected id values were:");
                for (Integer i : expected) {
                    logger.log(System.Logger.Level.ERROR, "id: " + i);
                }
                logger.log(System.Logger.Level.ERROR, "actual id values were:");
                Collections.sort(actual);
                for (Integer i : actual) {
                    logger.log(System.Logger.Level.ERROR, "id: " + i);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)ex);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("annotationMapKeyTest2 failed");
        }
    }
}

