/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaBuilder;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Customer_;
import ee.jakarta.tck.persistence.common.schema30.LineItem;
import ee.jakarta.tck.persistence.common.schema30.Order;
import ee.jakarta.tck.persistence.common.schema30.Order_;
import ee.jakarta.tck.persistence.common.schema30.UtilOrderData;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client6
extends UtilOrderData {
    private static final System.Logger logger = System.getLogger(Client6.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client6.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaBuilder6.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void avg() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Double.class);
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root order = cquery.from(Order.class);
            EntityType order_ = order.getModel();
            cquery.select((Selection)cbuilder.avg((Expression)order.get(order_.getSingularAttribute("totalPrice", Double.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Double d1 = 1487.29;
            Double d2 = 1487.3;
            Double d3 = (Double)tq.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                logger.log(System.Logger.Level.TRACE, "Avg test returned expected results: " + d1);
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("avg test  failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void max() throws Exception {
        boolean pass2 = false;
        boolean pass1 = false;
        Integer i1 = 8;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery1 = cbuilder.createQuery(Integer.class);
        CriteriaQuery cquery2 = cbuilder.createQuery(Integer.class);
        if (cquery1 != null && cquery2 != null) {
            Object result;
            logger.log(System.Logger.Level.TRACE, "select DISTINCT MAXIMUM number of lineItem quantities available an order may have");
            Root lineItem = cquery1.from(LineItem.class);
            EntityType lineItem_ = lineItem.getModel();
            cquery1.select((Selection)cbuilder.max((Expression)lineItem.get(lineItem_.getSingularAttribute("quantity", Integer.class))));
            cquery1.distinct(true);
            TypedQuery tq1 = this.getEntityManager().createQuery(cquery1);
            List i2 = tq1.getResultList();
            logger.log(System.Logger.Level.TRACE, "select MAXIMUM number of lineItem quantities available an order may have");
            Root lineItem2 = cquery2.from(LineItem.class);
            EntityType lineItem2_ = lineItem2.getModel();
            cquery2.select((Selection)cbuilder.max((Expression)lineItem2.get(lineItem2_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq2 = this.getEntityManager().createQuery(cquery2);
            List i3 = tq2.getResultList();
            logger.log(System.Logger.Level.INFO, "Verify select WITH DISTINCT keyword");
            if (i2.size() == 1) {
                result = (Integer)i2.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected results:" + (Integer)result);
                        pass1 = true;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected: " + i1 + ", actual:" + (Integer)result);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Receive null result from query");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Receive more than one result:");
                for (Integer i : i2) {
                    logger.log(System.Logger.Level.ERROR, "Received:" + i);
                }
            }
            logger.log(System.Logger.Level.INFO, "Verify select WITHOUT DISTINCT keyword");
            if (i3.size() == 1) {
                result = (Integer)i3.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected results:" + (Integer)result);
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected: " + i1 + ", actual:" + (Integer)result);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Receive null result from query");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Receive more than one result:");
                for (Integer i : i3) {
                    logger.log(System.Logger.Level.ERROR, "Received:" + i);
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("max test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void min() throws Exception {
        boolean pass2 = false;
        boolean pass1 = false;
        Integer i1 = 1;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery1 = cbuilder.createQuery(Integer.class);
        CriteriaQuery cquery2 = cbuilder.createQuery(Integer.class);
        if (cquery1 != null && cquery2 != null) {
            Object result;
            logger.log(System.Logger.Level.TRACE, "select DISTINCT MIN number of lineItem quantities available an order may have");
            Root lineItem = cquery1.from(LineItem.class);
            EntityType lineItem_ = lineItem.getModel();
            cquery1.select((Selection)cbuilder.min((Expression)lineItem.get(lineItem_.getSingularAttribute("quantity", Integer.class))));
            cquery1.distinct(true);
            TypedQuery tq1 = this.getEntityManager().createQuery(cquery1);
            List i2 = tq1.getResultList();
            logger.log(System.Logger.Level.TRACE, "select MIN number of lineItem quantities available an order may have");
            Root lineItem2 = cquery2.from(LineItem.class);
            EntityType lineItem2_ = lineItem2.getModel();
            cquery2.select((Selection)cbuilder.min((Expression)lineItem2.get(lineItem2_.getSingularAttribute("quantity", Integer.class))));
            TypedQuery tq2 = this.getEntityManager().createQuery(cquery2);
            List i3 = tq2.getResultList();
            logger.log(System.Logger.Level.INFO, "Verify select WITH DISTINCT keyword");
            if (i2.size() == 1) {
                result = (Integer)i2.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected results:" + (Integer)result);
                        pass1 = true;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected: " + i1 + ", actual:" + (Integer)result);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Receive null result from query");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Receive more than one result:");
                for (Integer i : i2) {
                    logger.log(System.Logger.Level.ERROR, "Received:" + i);
                }
            }
            logger.log(System.Logger.Level.INFO, "Verify select WITHOUT DISTINCT keyword");
            if (i3.size() == 1) {
                result = (Integer)i3.get(0);
                if (result != null) {
                    if (((Integer)result).equals(i1)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected results:" + (Integer)result);
                        pass2 = true;
                    } else {
                        logger.log(System.Logger.Level.TRACE, "Expected: " + i1 + ", actual:" + (Integer)result);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Receive null result from query");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Receive more than one result:");
                for (Integer i : i3) {
                    logger.log(System.Logger.Level.ERROR, "Received:" + i);
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("max test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void greatest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            logger.log(System.Logger.Level.TRACE, "find Greatest Order id Using lexicographic comparision");
            cquery.select((Selection)cbuilder.greatest((Expression)order.get(Order_2.getSingularAttribute("id", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String expectedResult = "9";
            String queryOutput = (String)tq.getSingleResult();
            if (queryOutput.equals(expectedResult)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result : " + expectedResult);
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Query returned : " + queryOutput + " Expected result : " + expectedResult);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("greatest test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void least() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            logger.log(System.Logger.Level.TRACE, "find least Order id Using lexicographic comparision");
            cquery.select((Selection)cbuilder.least((Expression)order.get(Order_2.getSingularAttribute("id", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            String expectedResult = "1";
            String queryOutput = (String)tq.getSingleResult();
            if (queryOutput.equals(expectedResult)) {
                logger.log(System.Logger.Level.TRACE, "Received expected result : " + expectedResult);
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Query returned : " + queryOutput + " Expected result : " + expectedResult);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("least test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void count() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Long.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)cbuilder.count((Expression)order.get(Order_2.getSingularAttribute("id", String.class))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            Long countResult = (Long)tq.getSingleResult();
            Long expectedCount = 20L;
            if (countResult.equals(expectedCount)) {
                logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "count test returned:" + countResult + "expected: " + expectedCount);
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("count test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void some() throws Exception {
        boolean pass = false;
        String[] expected = new String[18];
        for (int i = 0; i < 18; ++i) {
            expected[i] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Order_2 = mm.entity(Order.class);
            EntityType LineItem_ = mm.entity(LineItem.class);
            EntityType Customer_ = customer.getModel();
            CollectionJoin orders = customer.join(Customer_.getCollection("orders", Order.class));
            Subquery sq = cquery.subquery(Double.class);
            Root order = sq.from(Order.class);
            CollectionJoin lineItems = order.join(Order_2.getCollection("lineItemsCollection", LineItem.class));
            sq.select((Expression)order.get(Order_2.getSingularAttribute("totalPrice", Double.class))).where((Expression)cbuilder.equal((Expression)lineItems.get(LineItem_.getSingularAttribute("quantity", Integer.class)), (Object)3));
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.le((Expression)orders.get(Order_2.getSingularAttribute("totalPrice", Double.class)), cbuilder.some(sq)));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("some test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void any() throws Exception {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 18; ++i) {
            if (i == 9) continue;
            expected[j++] = this.customerRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Order_2 = mm.entity(Order.class);
            EntityType LineItem_ = mm.entity(LineItem.class);
            EntityType Customer_ = customer.getModel();
            CollectionJoin orders = customer.join(Customer_.getCollection("orders", Order.class));
            Subquery sq = cquery.subquery(Double.class);
            Root order = sq.from(Order.class);
            CollectionJoin lineItems = order.join(Order_2.getCollection("lineItemsCollection", LineItem.class));
            sq.select((Expression)order.get(Order_2.getSingularAttribute("totalPrice", Double.class))).where((Expression)cbuilder.equal((Expression)lineItems.get(LineItem_.getSingularAttribute("quantity")), (Object)3));
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.lt((Expression)orders.get(Order_2.getSingularAttribute("totalPrice", Double.class)), cbuilder.any(sq)));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("any test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void notPredicate() throws Exception {
        boolean pass = false;
        Double expectedTotalPrice = 4500.0;
        String[] expected = new String[]{this.orderRef[4].getId(), this.orderRef[10].getId(), this.orderRef[15].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.lt((Expression)order.get(Order_2.getSingularAttribute("totalPrice", Double.class)), (Number)expectedTotalPrice)));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notPredicate test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void conjunction() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[3].getId(), this.orderRef[8].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)cbuilder.isTrue((Expression)cbuilder.conjunction())));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("conjunction test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void disjunction() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[3].getId(), this.orderRef[8].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)cbuilder.isFalse((Expression)cbuilder.disjunction())));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("disjunction test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void isTrue() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[3].getId(), this.orderRef[8].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)cbuilder.isTrue((Expression)cbuilder.conjunction())));
            cquery.distinct(true);
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isTrue test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void isFalse() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[3].getId(), this.orderRef[8].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.equal((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"), (Expression)cbuilder.isFalse((Expression)cbuilder.disjunction())));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("isFalse test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void equalExpObjectTest() throws Exception {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 20; ++i) {
            if (i == 3 || !(i != 12 & i != 8)) continue;
            expected[j++] = this.orderRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.equal((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("equalExpObjectTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void equalExpExpTest() throws Exception {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 20; ++i) {
            if (i == 3 || !(i != 12 & i != 8)) continue;
            expected[j++] = this.orderRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.not((Expression)cbuilder.equal((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), cbuilder.literal((Object)"Robert E. Bissett"))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("equalExpExpTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void notEqualExpObjectTest() throws Exception {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 20; ++i) {
            if (i == 3 || !(i != 12 & i != 8)) continue;
            expected[j++] = this.orderRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.notEqual((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notEqualExpObjectTest test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void notEqualExpExpTest() throws Exception {
        boolean pass = false;
        int j = 0;
        String[] expected = new String[17];
        for (int i = 0; i < 20; ++i) {
            if (i == 3 || !(i != 12 & i != 8)) continue;
            expected[j++] = this.orderRef[i].getId();
        }
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Metamodel mm = this.getEntityManager().getMetamodel();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            EntityType Customer_ = mm.entity(Customer.class);
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.notEqual((Expression)order.get(Order_2.getSingularAttribute("customer", Customer.class)).get(Customer_.getSingularAttribute("name", String.class)), cbuilder.literal((Object)"Robert E. Bissett")));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("notEqualExpExpTest test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void abs() throws Exception {
        boolean pass = false;
        String[] expected = new String[]{this.orderRef[0].getId(), this.orderRef[1].getId(), this.orderRef[3].getId(), this.orderRef[4].getId(), this.orderRef[5].getId(), this.orderRef[10].getId(), this.orderRef[15].getId(), this.orderRef[16].getId(), this.orderRef[17].getId()};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Order.class);
        if (cquery != null) {
            Root order = cquery.from(Order.class);
            EntityType Order_2 = order.getModel();
            cquery.select((Selection)order);
            cquery.where((Expression)cbuilder.lt((Expression)cbuilder.parameter(Double.class, "dbl"), cbuilder.abs(cbuilder.neg((Expression)order.get(Order_2.getSingularAttribute("totalPrice", Double.class))))));
            TypedQuery tq = this.getEntityManager().createQuery(cquery);
            tq.setParameter("dbl", (Object)1180.0);
            List result = tq.getResultList();
            ArrayList<Integer> actual = new ArrayList<Integer>();
            for (Order o : result) {
                actual.add(Integer.parseInt(o.getId()));
            }
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("abs test failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void joinOnExpressionTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.join(Order_.lineItemsCollection, JoinType.INNER);
            Predicate exp = cbuilder.equal((Expression)lineItem.get("id"), (Object)"1");
            lineItem.on((Expression)exp);
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            throw new Exception("queryTest61 failed", e);
        }
        if (!pass) {
            throw new Exception("joinOnExpressionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @Test
    public void joinOnPredicateArrayTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            CollectionJoin lineItem = order.join(Order_.lineItemsCollection, JoinType.INNER);
            Predicate pred = lineItem.getOn();
            if (pred == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null from getOn()");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected getOn() to return null:");
                List lExp = pred.getExpressions();
                for (Object exp : lExp) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + exp.toString());
                }
            }
            Predicate[] predArray = new Predicate[]{cbuilder.equal((Expression)lineItem.get("id"), (Object)"1")};
            lineItem.on(predArray);
            pred = lineItem.getOn();
            if (pred == null) {
                logger.log(System.Logger.Level.ERROR, "Received null from getOn()");
            } else {
                pass2 = true;
                logger.log(System.Logger.Level.TRACE, "getOn() returned non-null:");
                List lExp = pred.getExpressions();
                for (Expression exp : lExp) {
                    logger.log(System.Logger.Level.TRACE, "actual:" + exp.toString());
                }
            }
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass3 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            throw new Exception("queryTest61 failed", e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("joinOnPredicateArrayTest failed");
        }
    }
}

