/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex3b;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex3b.DID3bDependent;
import ee.jakarta.tck.persistence.core.derivedid.ex3b.DID3bDependentId;
import ee.jakarta.tck.persistence.core.derivedid.ex3b.DID3bEmployee;
import ee.jakarta.tck.persistence.core.derivedid.ex3b.DID3bEmployeeId;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DID3bDependent", pkgName + "DID3bDependentId", pkgName + "DID3bEmployee", pkgName + "DID3bEmployeeId"};
        return this.createDeploymentJar("jpa_core_derivedid_ex3b.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void DIDTest() throws Exception {
        boolean pass = false;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            DID3bDependent newDependent2;
            this.getEntityTransaction().begin();
            DID3bEmployeeId eId1 = new DID3bEmployeeId("Java", "Duke");
            DID3bEmployeeId eId2 = new DID3bEmployeeId("C", "foo");
            DID3bEmployee employee1 = new DID3bEmployee(eId1);
            DID3bEmployee employee2 = new DID3bEmployee(eId2);
            DID3bDependentId depId1 = new DID3bDependentId("Obama", eId1);
            DID3bDependentId depId2 = new DID3bDependentId("Michelle", eId1);
            DID3bDependentId depId3 = new DID3bDependentId("John", eId2);
            DID3bDependent dep1 = new DID3bDependent(depId1, employee1);
            DID3bDependent dep2 = new DID3bDependent(depId2, employee1);
            DID3bDependent dep3 = new DID3bDependent(depId3, employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            logger.log(System.Logger.Level.TRACE, "persisted Employees and Dependents");
            this.getEntityManager().flush();
            DID3bDependent newDependent = (DID3bDependent)this.getEntityManager().find(DID3bDependent.class, (Object)depId1);
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            if ((newDependent2 = (DID3bDependent)this.getEntityManager().find(DID3bDependent.class, (Object)depId2)) != null) {
                this.getEntityManager().refresh((Object)newDependent2);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID3bDependent d where d.id.name='Obama' and d.emp.empId.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID3bDependent)depList.get(0);
                if (newDependent == dep1) {
                    pass1 = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Dependent not found");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
            }
            List depList2 = this.getEntityManager().createQuery("Select d from DID3bDependent d where d.id.name='Obama' and d.id.empPK.firstName='Java'").getResultList();
            newDependent2 = null;
            if (depList2.size() > 0) {
                newDependent2 = (DID3bDependent)depList.get(0);
                if (newDependent2 == dep1) {
                    pass2 = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Dependent not found");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (pass1 && pass2) {
            pass = true;
        }
        if (!pass) {
            throw new Exception("DIDTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

