/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactory;

import ee.jakarta.tck.persistence.common.PMClientBase;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Map;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    Properties props = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Member_", pkgName + "Member", pkgName + "Order_", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManagerFactory2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupNoData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupNoData");
        try {
            super.setup();
            this.createDeployment();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupNoData() throws Exception {
        try {
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void autoCloseableTest() throws Exception {
        EntityManagerFactory emf = null;
        try (EntityManagerFactory emfLocal = Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), (Map)this.getPersistenceUnitProperties());){
            emf = emfLocal;
            if (emf == null) {
                throw new Exception("autoCloseableTest failed: createEntityManagerFactory(String) returned null");
            }
            if (!emf.isOpen()) {
                throw new Exception("autoCloseableTest failed: EntityManagerFactory isOpen() returned false in try block");
            }
        }
        catch (Exception f) {
            throw f;
        }
        catch (Throwable t) {
            throw new Exception("autoCloseableTest failed with Exception", t);
        }
        finally {
            if (emf != null && emf.isOpen()) {
                throw new Exception("autoCloseableTest failed: EntityManagerFactory isOpen() returned true outside try block");
            }
        }
    }

    @Test
    public void getMetamodelTest() throws Exception {
        boolean pass = false;
        try {
            Metamodel mm = this.getEntityManager().getEntityManagerFactory().getMetamodel();
            if (mm == null) {
                logger.log(System.Logger.Level.ERROR, "getMetamodel() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getMetamodelTest failed");
        }
    }

    @Test
    public void getPersistenceUnitUtil() throws Exception {
        boolean pass = false;
        try {
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            if (puu == null) {
                logger.log(System.Logger.Level.ERROR, "getPersistenceUnitUtil() returned a null result");
            } else {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getPersistenceUnitUtil failed");
        }
    }

    @Test
    public void getCriteriaBuilderTest() throws Exception {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
            if (cbuilder != null) {
                this.getEntityTransaction().begin();
                CriteriaQuery cquery = cbuilder.createQuery();
                if (cquery != null) {
                    logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
                }
                this.getEntityTransaction().commit();
            } else {
                logger.log(System.Logger.Level.ERROR, "getCriteriaBuilder() returned null");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getCriteriaBuilderTest failed");
        }
    }
}

