/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entitytest.bigdecimal;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entitytest.bigdecimal.A;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        return this.createDeploymentJar("jpa_core_entitytest_bigdecimal.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest1");
        boolean pass = false;
        try {
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("1", "a1", 1, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityTransaction().begin();
            if (!this.getInstanceStatus(aRef)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest2");
        boolean pass = false;
        A aRef = null;
        try {
            logger.log(System.Logger.Level.TRACE, "new A");
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            aRef = new A("2", "a2", 2, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.createA(aRef);
            A newA = this.findA(bigDecimal);
            if (newA != null) {
                logger.log(System.Logger.Level.TRACE, "A IS NOT NULL");
            }
            this.getEntityTransaction().begin();
            pass = this.getInstanceStatus(this.findA(bigDecimal));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest3() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest3");
        Object aName = null;
        boolean pass = false;
        A result = null;
        A a1 = null;
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            a1 = new A("3", "a3", 3, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            logger.log(System.Logger.Level.TRACE, "find By Name");
            result = (A)this.findByName("a3");
            logger.log(System.Logger.Level.TRACE, "Check to see that the entities are identical");
            if (result == a1) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back transaction", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest4() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest4");
        boolean pass = false;
        A aRef = null;
        try {
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            aRef = new A("4", "a4", 4, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.createA(aRef);
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            if (this.getInstanceStatus(this.findA(bigDecimal))) {
                try {
                    logger.log(System.Logger.Level.TRACE, "entity is managed, try to persist again ");
                    A newA = this.findA(bigDecimal);
                    this.getEntityManager().persist((Object)newA);
                    logger.log(System.Logger.Level.TRACE, "Persist ignored on an already persisted entity as expected");
                    pass = true;
                }
                catch (Exception ee) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception trying to persist an already persisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not managed. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistBasicTest5() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin persistBasicTest5");
        A a2 = null;
        A aRef = null;
        boolean pass = false;
        try {
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            aRef = new A("5", "a5", 5, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            logger.log(System.Logger.Level.TRACE, "Persist Instance");
            this.createA(aRef);
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "get Instance Status ");
            if (this.getInstanceStatus(this.findA(bigDecimal))) {
                try {
                    logger.log(System.Logger.Level.TRACE, "entity is managed, try to change name and flush ");
                    a2 = this.findA(bigDecimal);
                    a2.setName("a2");
                    this.getEntityManager().flush();
                    if (a2.getName().equals("a2")) {
                        logger.log(System.Logger.Level.TRACE, "sync to database successful");
                        pass = true;
                    }
                }
                catch (Exception ee) {
                    logger.log(System.Logger.Level.ERROR, "Unexpected exception trying to flush apersisted entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                logger.log(System.Logger.Level.TRACE, "Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back transaction", (Throwable)re);
            }
        }
        if (!pass) {
            throw new Exception("persistBasicTest5 failed");
        }
    }

    private void createA(A a) {
        logger.log(System.Logger.Level.TRACE, "Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(BigDecimal id) {
        logger.log(System.Logger.Level.TRACE, "Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private Object findByName(String name) {
        logger.log(System.Logger.Level.TRACE, "Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getSingleResult();
    }

    private boolean getInstanceStatus(Object o) {
        logger.log(System.Logger.Level.TRACE, "Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BIGDECIMAL").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

