/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.inheritance.mappedsc.annotation;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.inheritance.mappedsc.annotation.Employee;
import ee.jakarta.tck.persistence.core.inheritance.mappedsc.annotation.FullTimeEmployee;
import ee.jakarta.tck.persistence.core.inheritance.mappedsc.annotation.PartTimeEmployee;
import java.sql.Date;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    private static final FullTimeEmployee[] ftRef = new FullTimeEmployee[5];
    private static final PartTimeEmployee[] ptRef = new PartTimeEmployee[5];
    private final Date d1 = this.getSQLDate(2000, 2, 14);
    private final Date d2 = this.getSQLDate(2001, 6, 27);
    private final Date d3 = this.getSQLDate(2002, 7, 7);
    private final Date d4 = this.getSQLDate(2003, 3, 3);
    private final Date d5 = this.getSQLDate(2004, 4, 10);
    private final Date d6 = this.getSQLDate(2005, 2, 18);
    private final Date d7 = this.getSQLDate(2000, 9, 17);
    private final Date d8 = this.getSQLDate(2001, 11, 14);
    private final Date d9 = this.getSQLDate(2002, 10, 4);
    private final Date d10 = this.getSQLDate(2003, 1, 25);

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "AbstractPersonnel", pkgName + "Department", pkgName + "Employee", pkgName + "FullTimeEmployee", pkgName + "PartTimeEmployee", pkgName + "Project"};
        return this.createDeploymentJar("jpa_core_inheritance_mappedsc_annotation.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData();
            logger.log(System.Logger.Level.TRACE, "Done creating test data");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void test1() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test1");
        boolean pass = false;
        try {
            FullTimeEmployee ftEmp1 = (FullTimeEmployee)this.getEntityManager().find(FullTimeEmployee.class, (Object)1);
            if (ftEmp1.getFullTimeRep().equals("Mabel Murray")) {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test1 failed");
        }
    }

    @Test
    public void test2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin test2");
        boolean pass = false;
        try {
            PartTimeEmployee ptEmp1 = (PartTimeEmployee)this.getEntityManager().find(PartTimeEmployee.class, (Object)6);
            if (ptEmp1.getPartTimeRep().equals("John Cleveland")) {
                pass = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() {
        logger.log(System.Logger.Level.TRACE, "createTestData");
        try {
            this.getEntityTransaction().begin();
            Client.ftRef[0] = new FullTimeEmployee(1, "Jonathan", "Smith", this.d10, 40000.0f);
            Client.ftRef[1] = new FullTimeEmployee(2, "Mary", "Macy", this.d9, 40000.0f);
            Client.ftRef[2] = new FullTimeEmployee(3, "Sid", "Nee", this.d8, 40000.0f);
            Client.ftRef[3] = new FullTimeEmployee(4, "Julie", "OClaire", this.d7, 60000.0f);
            Client.ftRef[4] = new FullTimeEmployee(5, "Steven", "Rich", this.d6, 60000.0f);
            logger.log(System.Logger.Level.TRACE, "Persist full time employees ");
            for (FullTimeEmployee fullTimeEmployee : ftRef) {
                if (fullTimeEmployee == null) continue;
                this.getEntityManager().persist((Object)fullTimeEmployee);
                logger.log(System.Logger.Level.TRACE, "persisted employee " + fullTimeEmployee);
            }
            Client.ptRef[0] = new PartTimeEmployee(6, "Kellie", "Lee", this.d5, 60000.0f);
            Client.ptRef[1] = new PartTimeEmployee(7, "Nicole", "Martin", this.d4, 60000.0f);
            Client.ptRef[2] = new PartTimeEmployee(8, "Mark", "Francis", this.d3, 60000.0f);
            Client.ptRef[3] = new PartTimeEmployee(9, "Will", "Forrest", this.d2, 60000.0f);
            Client.ptRef[4] = new PartTimeEmployee(10, "Katy", "Hughes", this.d1, 60000.0f);
            logger.log(System.Logger.Level.TRACE, "Persist part time employees ");
            for (Employee employee : ptRef) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                this.getEntityManager().flush();
                logger.log(System.Logger.Level.TRACE, "persisted employee " + (PartTimeEmployee)employee);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception re) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception rolling back TX:", (Throwable)re);
            }
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PARTTIMEEMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

