/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.delete;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.delete.ADVC;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.delete.ALocal;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.delete.ALocalHome;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.delete.BDVC;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.delete.BLocal;
import com.sun.ts.tests.ejb.ee.pm.oneXmany.bi.delete.BLocalHome;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public abstract class BeanEJB
implements EntityBean {
    private EntityContext context = null;
    private TSNamingContext nctx = null;
    private static final int NO_RELATION_SET = 0;
    private static final int NULL_RELATION_SET = 1;
    private static final int RELATION_SET = 2;
    private static final String ALocal = "java:comp/env/ejb/ALocal";
    private static final String BLocal = "java:comp/env/ejb/BLocal";

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract int getValue();

    public abstract void setValue(int var1);

    public abstract ALocal getA1();

    public abstract void setA1(ALocal var1);

    public abstract ALocal getA2();

    public abstract void setA2(ALocal var1);

    public abstract BLocal getB1();

    public abstract void setB1(BLocal var1);

    public abstract BLocal getB2();

    public abstract void setB2(BLocal var1);

    private ALocal createALocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createALocal");
        TestUtil.logMsg((String)"Obtain naming context");
        this.nctx = new TSNamingContext();
        ALocalHome aLocalHome = (ALocalHome)this.nctx.lookup(ALocal);
        ALocal aLocal = aLocalHome.create(id, name, value);
        return aLocal;
    }

    private BLocal createBLocal(String id, String name, int value) throws Exception {
        TestUtil.logTrace((String)"createBLocal");
        TestUtil.logMsg((String)"Obtain naming context");
        this.nctx = new TSNamingContext();
        BLocalHome bLocalHome = (BLocalHome)this.nctx.lookup(BLocal);
        BLocal bLocal = bLocalHome.create(id, name, value);
        return bLocal;
    }

    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean test1() {
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal bTwo = null;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            bTwo = this.getB2();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)("bTwo = " + bTwo));
            TestUtil.logMsg((String)"Delete entitybean objects A1, B1, and B2");
            aOne.remove();
            bOne.remove();
            bTwo.remove();
            TestUtil.logMsg((String)"Attempt to call a method on A1");
            aOne.getId();
            TestUtil.logErr((String)"Entitybean object A1 was not deleted, expected EJBException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"Entitybean object A1 was deleted");
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test2() {
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal bTwo = null;
        boolean part1 = true;
        boolean part2 = true;
        try {
            BLocal b;
            Iterator iterator;
            aOne = this.getA1();
            bOne = this.getB1();
            bTwo = this.getB2();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)("bTwo = " + bTwo));
            TestUtil.logMsg((String)"Delete entitybean object B1");
            bOne.remove();
            TestUtil.logMsg((String)"Check relationship accessor method of entitybean object A1");
            TestUtil.logMsg((String)"Calling Collection c = aOne.getB()");
            Collection c = aOne.getB();
            TestUtil.logMsg((String)"Check size of collection returned");
            if (c.size() == 1) {
                TestUtil.logMsg((String)"Collection size returned is 1");
                TestUtil.logMsg((String)"Check contents of collection returned");
                iterator = c.iterator();
                b = (BLocal)iterator.next();
                if (b.getValue() == 12) {
                    TestUtil.logMsg((String)"Collection contents is correct");
                } else {
                    TestUtil.logErr((String)("Collection contents is incorrect B(" + b.getId() + ", " + b.getName() + ", " + b.getValue() + "),  expected B(12, b12, 12)"));
                    part1 = false;
                }
            } else {
                TestUtil.logErr((String)("Collection size returned is " + c.size() + ", expected 1"));
                TestUtil.logErr((String)"Entitybean object B1 was not removed from collection");
                part1 = false;
            }
            TestUtil.logMsg((String)"Check relationship accessor method of BeanEJB");
            TestUtil.logMsg((String)"Calling c = getA1().getB()");
            c = this.getA1().getB();
            TestUtil.logMsg((String)"Check size of collection returned");
            if (c.size() == 1) {
                TestUtil.logMsg((String)"Collection size returned is 1");
                TestUtil.logMsg((String)"Check contents of collection returned");
                iterator = c.iterator();
                b = (BLocal)iterator.next();
                if (b.getValue() == 12) {
                    TestUtil.logMsg((String)"Collection contents is correct");
                } else {
                    TestUtil.logErr((String)("Collection contents is incorrect B(" + b.getId() + ", " + b.getName() + ", " + b.getValue() + "),  expected B(12, b12, 12)"));
                    part2 = false;
                }
            } else {
                TestUtil.logErr((String)("Collection size returned is " + c.size() + ", expected 1"));
                TestUtil.logErr((String)"Entitybean object B1 was not removed from collection");
                part2 = false;
            }
            return part1 && part2;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test3() {
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal bTwo = null;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            bTwo = this.getB2();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)("bTwo = " + bTwo));
            TestUtil.logMsg((String)"Delete entitybean objects A1, B1, and B2");
            aOne.remove();
            bOne.remove();
            bTwo.remove();
            TestUtil.logMsg((String)"Accessor method of A1 must throw EJBException");
            TestUtil.logMsg((String)"Calling aOne.getId()");
            aOne.getId();
            TestUtil.logErr((String)"Did not get expected EJBException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Caught expected EJBException");
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            return false;
        }
    }

    public boolean test4() {
        ALocal aOne = null;
        BLocal bOne = null;
        BLocal bTwo = null;
        Collection bcol = null;
        try {
            aOne = this.getA1();
            bOne = this.getB1();
            bTwo = this.getB2();
            TestUtil.logMsg((String)("aOne = " + aOne));
            TestUtil.logMsg((String)("bOne = " + bOne));
            TestUtil.logMsg((String)("bTwo = " + bTwo));
            TestUtil.logMsg((String)"Delete entitybean object B1");
            bOne.remove();
            TestUtil.logMsg((String)"Delete entitybean object B2");
            bTwo.remove();
            TestUtil.logMsg((String)"Assigning B1 to collection must throw IllegalArgumentException");
            TestUtil.logMsg((String)"Calling bcol.add(bOne) and aOne.setB(bcol)");
            bcol = aOne.getB();
            bcol.add(bOne);
            TestUtil.logErr((String)"Did not get expected IllegalArgumentException");
            return false;
        }
        catch (IllegalArgumentException e) {
            TestUtil.logMsg((String)"Caught expected IllegalArgumentException");
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected exception: " + e), (Throwable)e);
            return false;
        }
    }

    private Collection getBInfoFromA() {
        TestUtil.logTrace((String)"getBInfoFromA");
        Vector<BDVC> v = new Vector<BDVC>();
        if (this.getA1() != null) {
            Collection bcol = this.getA1().getB();
            for (BLocal b : bcol) {
                BDVC bDVC = new BDVC(b.getId(), b.getName(), b.getValue());
                v.add(bDVC);
            }
        }
        return v;
    }

    private Collection getAInfoFromB() {
        TestUtil.logTrace((String)"getAInfoFromB");
        Vector<ADVC> v = new Vector<ADVC>();
        if (this.getA1() != null) {
            Collection bcol = this.getA1().getB();
            for (BLocal b : bcol) {
                ALocal a = b.getA();
                ADVC aDVC = new ADVC(a.getId(), a.getName(), a.getValue());
                v.add(aDVC);
            }
        }
        return v;
    }

    private Collection copyCollection(Collection c) {
        Vector copy = new Vector();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            copy.add(iterator.next());
        }
        return copy;
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, BDVC bOne, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, BDVC bOne, int flag) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            this.setA1(a1);
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            this.setB1(b1);
            switch (flag) {
                case 0: {
                    break;
                }
                case 1: {
                    a1.setB(null);
                    b1.setA(null);
                    break;
                }
                case 2: {
                    Collection c = a1.getB();
                    c.add(b1);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public String ejbCreate(String id, String name, int value, ADVC aOne, BDVC bOne, BDVC bTwo) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            this.setId(id);
            this.setName(name);
            this.setValue(value);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(String id, String name, int value, ADVC aOne, BDVC bOne, BDVC bTwo) throws CreateException {
        TestUtil.logTrace((String)"ejbPostCreate");
        try {
            ALocal a1 = this.createALocal(aOne.getId(), aOne.getName(), aOne.getValue());
            this.setA1(a1);
            Collection bcol1 = a1.getB();
            BLocal b1 = this.createBLocal(bOne.getId(), bOne.getName(), bOne.getValue());
            this.setB1(b1);
            bcol1.add(b1);
            BLocal b2 = this.createBLocal(bTwo.getId(), bTwo.getName(), bTwo.getValue());
            this.setB2(b2);
            bcol1.add(b2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.context = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception occurred: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
        TestUtil.logMsg((String)("getA1() = " + this.getA1()));
        TestUtil.logMsg((String)("getA2() = " + this.getA2()));
        TestUtil.logMsg((String)("getB1() = " + this.getB1()));
        TestUtil.logMsg((String)("getB2() = " + this.getB2()));
        if (this.getA1() != null) {
            TestUtil.logMsg((String)"deleting entitybean object A1 ...");
            this.getA1().remove();
        }
        if (this.getA2() != null) {
            TestUtil.logMsg((String)"deleting entitybean object A2 ...");
            this.getA2().remove();
        }
        if (this.getB1() != null) {
            TestUtil.logMsg((String)"deleting entitybean object B1 ...");
            this.getB1().remove();
        }
        if (this.getB2() != null) {
            TestUtil.logMsg((String)"deleting entitybean object B2 ...");
            this.getB2().remove();
        }
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }
}

