/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.ejbweb;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.ejbweb.EjbClientIF;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSConnectionFactory;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSPasswordCredential;
import javax.jms.JMSSessionMode;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.transaction.UserTransaction;

@Stateful(name="CDITestsEjbWebClntBean")
@Remote(value={EjbClientIF.class})
public class EjbClient
implements EjbClientIF {
    private static final boolean debug = false;
    private static final long serialVersionUID = 1L;
    long timeout;
    private static int testsExecuted = 0;
    @Inject
    @JMSConnectionFactory(value="jms/QueueConnectionFactory")
    transient JMSContext context1;
    @Inject
    @JMSConnectionFactory(value="jms/TopicConnectionFactory")
    transient JMSContext context2;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    @JMSPasswordCredential(userName="j2ee", password="j2ee")
    @JMSSessionMode(value=3)
    transient JMSContext context3;
    @Inject
    transient JMSContext context4;
    @Resource(name="jms/MyConnectionFactory")
    private transient ConnectionFactory cfactory;
    @Resource(name="jms/MyQueueConnectionFactory")
    private transient QueueConnectionFactory qcfactory;
    @Resource(name="jms/MyTopicConnectionFactory")
    private transient TopicConnectionFactory tcfactory;
    @Resource(name="jms/MY_QUEUE")
    private transient Queue queue;
    @Resource(name="jms/MY_TOPIC")
    private transient Topic topic;

    private String printSessionMode(int sessionMode) {
        switch (sessionMode) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        return "UNEXPECTED_SESSIONMODE";
    }

    private void cleanup() {
        TestUtil.logMsg((String)"cleanup");
    }

    @PostConstruct
    public void postConstruct() {
        System.out.println("EjbClient:postConstruct()");
        System.out.println("queue=" + this.queue);
        System.out.println("topic=" + this.topic);
        System.out.println("cfactory=" + this.cfactory);
        System.out.println("qcfactory=" + this.qcfactory);
        System.out.println("tcfactory=" + this.tcfactory);
        if (this.queue == null || this.topic == null || this.context1 == null || this.context2 == null || this.context3 == null || this.context4 == null || this.cfactory == null || this.qcfactory == null || this.tcfactory == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        try {
            TestUtil.init((Properties)p);
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
    }

    @Override
    public boolean echo(String testName) {
        boolean pass = false;
        if (testName.equals("sendRecvQueueTestUsingCDIFromEjb")) {
            pass = this.sendRecvQueueTestUsingCDIFromEjb();
        } else if (testName.equals("sendRecvTopicTestUsingCDIFromEjb")) {
            pass = this.sendRecvTopicTestUsingCDIFromEjb();
        } else if (testName.equals("sendRecvUsingCDIDefaultFactoryFromEjb")) {
            pass = this.sendRecvUsingCDIDefaultFactoryFromEjb();
        } else if (testName.equals("verifySessionModeOnCDIJMSContextFromEjb")) {
            pass = this.verifySessionModeOnCDIJMSContextFromEjb();
        } else if (testName.equals("testRestrictionsOnCDIJMSContextFromEjb")) {
            pass = this.testRestrictionsOnCDIJMSContextFromEjb();
        } else if (testName.equals("testActiveJTAUsingCDICallMethod1FromEjb")) {
            pass = this.testActiveJTAUsingCDICallMethod1FromEjb();
        } else if (testName.equals("testActiveJTAUsingCDICallMethod2FromEjb")) {
            pass = this.testActiveJTAUsingCDICallMethod2FromEjb();
        }
        this.cleanup();
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvQueueTestUsingCDIFromEjb() {
        boolean pass = true;
        JMSConsumer consumer = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TestUtil.logMsg((String)"Using CDI injected context1 specifying QueueConnectionFactory");
            consumer = this.context1.createConsumer((Destination)this.queue);
            TestUtil.logMsg((String)"Creating TextMessage");
            messageSent = this.context1.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvQueueTestUsingCDIFromEjb");
            TestUtil.logMsg((String)"Sending TextMessage");
            this.context1.createProducer().send((Destination)this.queue, (Message)messageSent);
            TestUtil.logMsg((String)"Receiving TextMessage");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"No message was received");
                pass = false;
            } else {
                TestUtil.logMsg((String)("Message Sent: \"" + messageSent.getText() + "\""));
                TestUtil.logMsg((String)("Message Received: \"" + messageReceived.getText() + "\""));
                if (messageReceived.getText().equals(messageSent.getText())) {
                    TestUtil.logMsg((String)"Received correct message");
                } else {
                    TestUtil.logErr((String)"Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvTopicTestUsingCDIFromEjb() {
        boolean pass = true;
        JMSConsumer consumer = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TestUtil.logMsg((String)"Using CDI injected context2 specifying TopicConnectionFactory");
            consumer = this.context2.createConsumer((Destination)this.topic);
            TestUtil.logMsg((String)"Creating TextMessage");
            messageSent = this.context2.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvTopicTestUsingCDIFromEjb");
            TestUtil.logMsg((String)"Sending TextMessage");
            this.context2.createProducer().send((Destination)this.topic, (Message)messageSent);
            TestUtil.logMsg((String)"Receiving TextMessage");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"No message was received");
                pass = false;
            } else {
                TestUtil.logMsg((String)("Message Sent: \"" + messageSent.getText() + "\""));
                TestUtil.logMsg((String)("Message Received: \"" + messageReceived.getText() + "\""));
                if (messageReceived.getText().equals(messageSent.getText())) {
                    TestUtil.logMsg((String)"Received correct message");
                } else {
                    TestUtil.logErr((String)"Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvUsingCDIDefaultFactoryFromEjb() {
        boolean pass = true;
        JMSConsumer consumer = null;
        JMSConsumer consumer2 = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            TestUtil.logMsg((String)"Using CDI injected context4 using default system connection factory");
            TestUtil.logMsg((String)"Creating Consumer for Queue");
            consumer = this.context4.createConsumer((Destination)this.queue);
            TestUtil.logMsg((String)"Creating Consumer for Topic");
            consumer2 = this.context4.createConsumer((Destination)this.topic);
            TestUtil.logMsg((String)"Creating TextMessage");
            messageSent = this.context4.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvUsingCDIDefaultFactoryFromEjb");
            TestUtil.logMsg((String)"Sending TextMessage to Queue");
            this.context4.createProducer().send((Destination)this.queue, (Message)messageSent);
            TestUtil.logMsg((String)"Sending TextMessage to Topic");
            this.context4.createProducer().send((Destination)this.topic, (Message)messageSent);
            TestUtil.logMsg((String)"Receiving TextMessage from Queue consumer");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            TestUtil.logMsg((String)"Receiving TextMessage from Topic consumer");
            messageReceived2 = (TextMessage)consumer2.receive(this.timeout);
            TestUtil.logMsg((String)"Check received message from Queue consumer");
            if (messageReceived == null) {
                TestUtil.logErr((String)"No message was received");
                pass = false;
            } else {
                TestUtil.logMsg((String)("Message Sent: \"" + messageSent.getText() + "\""));
                TestUtil.logMsg((String)("Message Received: \"" + messageReceived.getText() + "\""));
                if (messageReceived.getText().equals(messageSent.getText())) {
                    TestUtil.logMsg((String)"Received correct message");
                } else {
                    TestUtil.logErr((String)"Received incorrect message");
                    pass = false;
                }
            }
            TestUtil.logMsg((String)"Check received message from Topic consumer");
            if (messageReceived2 == null) {
                TestUtil.logErr((String)"No message was received");
                pass = false;
            } else {
                TestUtil.logMsg((String)("Message Sent: \"" + messageSent.getText() + "\""));
                TestUtil.logMsg((String)("Message Received: \"" + messageReceived2.getText() + "\""));
                if (messageReceived2.getText().equals(messageSent.getText())) {
                    TestUtil.logMsg((String)"Received correct message");
                } else {
                    TestUtil.logErr((String)"Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
                consumer2.receive(this.timeout);
                while (consumer2.receiveNoWait() != null) {
                }
                consumer2.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    public boolean verifySessionModeOnCDIJMSContextFromEjb() {
        boolean pass = true;
        System.out.println("verifySessionModeOnCDIJMSContextFromEjb");
        try {
            TestUtil.logMsg((String)("Checking session mode of context3 should be " + this.printSessionMode(3)));
            if (this.context3.getSessionMode() != 3) {
                TestUtil.logErr((String)("Incorrect session mode returned: " + this.printSessionMode(this.context3.getSessionMode()) + "  expected: " + this.printSessionMode(3)));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Returned correct session mode: " + this.printSessionMode(3)));
            }
            TestUtil.logMsg((String)("Checking session mode of context2 should be " + this.printSessionMode(1)));
            if (this.context2.getSessionMode() != 1) {
                TestUtil.logErr((String)("Incorrect session mode returned: " + this.printSessionMode(this.context2.getSessionMode()) + "  expected: " + this.printSessionMode(1)));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Returned correct session mode: " + this.printSessionMode(1)));
            }
            TestUtil.logMsg((String)("Checking session mode of context1 should be " + this.printSessionMode(1)));
            if (this.context1.getSessionMode() != 1) {
                TestUtil.logErr((String)("Incorrect session mode returned: " + this.printSessionMode(this.context1.getSessionMode()) + "  expected: " + this.printSessionMode(1)));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Returned correct session mode: " + this.printSessionMode(1)));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        return pass;
    }

    public boolean testRestrictionsOnCDIJMSContextFromEjb() {
        boolean pass = true;
        System.out.println("testRestrictionsOnCDIJMSContextFromEjb");
        try {
            TestUtil.logMsg((String)"Calling JMSContext.acknowledge() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.acknowledge();
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.setClientID(String) MUST throw IllegalStateRuntimeException");
            try {
                this.context1.setClientID("test");
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.setExceptionListener(ExceptionListener) MUST throw IllegalStateRuntimeException");
            try {
                this.context1.setExceptionListener(null);
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.start() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.start();
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.stop() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.stop();
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.commit() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.commit();
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.rollback() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.rollback();
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.recover() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.recover();
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.setAutoStart(boolean) MUST throw IllegalStateRuntimeException");
            try {
                this.context1.setAutoStart(true);
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
            TestUtil.logMsg((String)"Calling JMSContext.close() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.close();
            }
            catch (IllegalStateRuntimeException e) {
                TestUtil.logMsg((String)"Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught unexpected Exception: " + e));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        return pass;
    }

    public boolean testActiveJTAUsingCDICallMethod1FromEjb() {
        boolean pass = true;
        Object consumer = null;
        try {
            TestUtil.logMsg((String)"Enter testActiveJTAUsingCDICallMethod1FromEjb");
            TextMessage messageSent = null;
            Object messageReceived = null;
            TSNamingContext nctx = new TSNamingContext();
            UserTransaction ut = (UserTransaction)nctx.lookup("java:comp/UserTransaction");
            TestUtil.logMsg((String)"Start a JTA transaction");
            ut.begin();
            TestUtil.logMsg((String)"Create TextMessage");
            messageSent = this.context4.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "testActiveJTAUsingCDICallMethod1FromEjb");
            TestUtil.logMsg((String)"Send TextMessage");
            this.context4.createProducer().send((Destination)this.queue, (Message)messageSent);
            TestUtil.logMsg((String)"Exit method and let the next method call complete the JTA transaction");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testActiveJTAUsingCDICallMethod2FromEjb() {
        boolean pass = true;
        JMSConsumer consumer = null;
        try {
            TestUtil.logMsg((String)"Enter testActiveJTAUsingCDICallMethod2FromEjb");
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TSNamingContext nctx = new TSNamingContext();
            UserTransaction ut = (UserTransaction)nctx.lookup("java:comp/UserTransaction");
            TestUtil.logMsg((String)"Commit the JTA transaction from previous method");
            ut.commit();
            TestUtil.logMsg((String)"Create JMSConsumer to consume TextMessage sent in previous method");
            consumer = this.context4.createConsumer((Destination)this.queue);
            messageSent = this.context4.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "testActiveJTAUsingCDICallMethod2FromEjb");
            TestUtil.logMsg((String)"Receiving TextMessage sent in previous method");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                TestUtil.logErr((String)"No message was received");
                pass = false;
            } else {
                TestUtil.logMsg((String)("Message Sent: \"" + messageSent.getText() + "\""));
                TestUtil.logMsg((String)("Message Received: \"" + messageReceived.getText() + "\""));
                if (messageReceived.getText().equals(messageSent.getText())) {
                    TestUtil.logMsg((String)"Received correct message");
                } else {
                    TestUtil.logErr((String)"Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }
}

