/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.nullhandling;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.NillableContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.NillablePropertyContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.NillablePropertyNonNillableContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.NonNillableContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.NonNillablePropertyContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.NonNillablePropertyNillableContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.SimpleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.nillable.NillablePackageNillablePropertyNonNillableContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.nillable.NillablePackageNonNillablePropertyContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.nillable.NillablePackageSimpleContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.nonnillable.NonNillablePackageNillableContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.nonnillable.NonNillablePackageNonNillablePropertyNillableContainer;
import com.sun.ts.tests.jsonb.customizedmapping.nullhandling.model.nonnillable.NonNillablePackageSimpleContainer;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;

public class NullHandlingCustomizationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        NullHandlingCustomizationTest t = new NullHandlingCustomizationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testNillableType() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NillableContainer());
        if (!jsonString.matches("\\{\\s*\"stringInstance\"\\s*\\:\\s*null\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal null property of type annotated as JsonbNillable.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNillablePackage() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NillablePackageSimpleContainer());
        if (!jsonString.matches("\\{\\s*\"stringInstance\"\\s*\\:\\s*null\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal null property of type under package annotated as JsonbNillable.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNillableProperty() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NillablePropertyContainer());
        if (!jsonString.matches("\\{\\s*\"nillableStringInstance\"\\s*\\:\\s*null\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal null property annotated as JsonbProperty with nillable = true.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNullValuesConfig() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new SimpleContainer());
        if (!jsonString.matches("\\{\\s*\"stringInstance\"\\s*\\:\\s*null\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal null properties when using JsonbConfig().withNullValues(true).");
        }
        return Status.passed((String)"OK");
    }

    public Status testNillableTypeNonNillableProperty() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NonNillablePropertyNillableContainer());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly ignore null property annotated as JsonbProperty with nillable = false of type annotated as JsonbNillable.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNillablePackageNonNillableProperty() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NillablePackageNonNillablePropertyContainer());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly ignore null property annotated as JsonbProperty(nillable = false) of type under package annotated as JsonbNillable.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNillablePackageNonNillableTypeNillableProperty() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new NillablePackageNillablePropertyNonNillableContainer());
        if (!jsonString.matches("\\{\\s*\"nillableStringInstance\"\\s*\\:\\s*null\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal null property annotated as JsonbProperty(nillable = true) of type annotated as JsonbNillable(false) under package annotated as JsonbNillable.");
        }
        return Status.passed((String)"OK");
    }

    public Status testNullValuesConfigNonNillablePackage() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillablePackageSimpleContainer());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly ignore null properties when using JsonbConfig().withNullValues(true) and type under package annotated as JsonbNillable(false).");
        }
        return Status.passed((String)"OK");
    }

    public Status testNullValuesConfigNonNillablePackageNillableType() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillablePackageNillableContainer());
        if (!jsonString.matches("\\{\\s*\"stringInstance\"\\s*\\:\\s*null\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly marshal null properties when using JsonbConfig().withNullValues(true) and type annotated as JsonbNillable under package annotated as JsonbNillable(false).");
        }
        return Status.passed((String)"OK");
    }

    public Status testNullValuesConfigNonNillablePackageNillableTypeNonNillableProperty() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillablePackageNonNillablePropertyNillableContainer());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly ignore null property annotated as JsonbProperty with nillable = false when using JsonbConfig().withNullValues(true) and type annotated as JsonbNillable under package annotated as JsonbNillable(false).");
        }
        return Status.passed((String)"OK");
    }

    public Status testNullValuesConfigNonNillableType() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillableContainer());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly ignore null property when using JsonbConfig().withNullValues(true) and type annotated as JsonbNillable(false).");
        }
        return Status.passed((String)"OK");
    }

    public Status testNullValuesConfigNonNillableTypeNillableProperty() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NillablePropertyNonNillableContainer());
        if (!jsonString.matches("\\{\\s*\"nillableStringInstance\"\\s*\\:\\s*null\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly include null property annotated as JsonbProperty with nillable = true when using JsonbConfig().withNullValues(true) and type annotated as JsonbNillable(false).");
        }
        return Status.passed((String)"OK");
    }

    public Status testNullValuesConfigNonNillableProperty() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillablePropertyContainer());
        if (!jsonString.matches("\\{\\s*\\}")) {
            throw new EETest.Fault("Failed to correctly ignore null property annotated as JsonbProperty with nillable = false when using JsonbConfig().withNullValues(true).");
        }
        return Status.passed((String)"OK");
    }
}

