/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.cmp20.entitycontexttest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.entitycontexttest.FastPath;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.entitycontexttest.FastPathHome;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.entitycontexttest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.entitycontexttest.TestBeanHome;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.CreateException;

public class Client
extends EETest {
    private static final String ENV_ENTRY_NAME = "user";
    private static final String ENV_ENTRY_VALUE = "cts1";
    private static final String testName = "EntityContextTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String testProps = "entitycontexttest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private Properties props = null;
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private TSNamingContext nctx = null;
    private static final String user = "user";
    private static final String password = "password";
    private String user_value;
    private String password_value;
    private String role1_value = "Employee";
    private String role2_value = "Manager";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        this.user_value = this.props.getProperty("user");
        this.password_value = this.props.getProperty(password);
        this.logMsg("user_value=" + this.user_value);
        this.logMsg("password_value=" + this.password_value);
        this.logMsg("role1_value=" + this.role1_value);
        this.logMsg("role2_value=" + this.role2_value);
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Obtain login context and login as: " + this.user_value);
            TSLoginContext lc = new TSLoginContext();
            lc.login(this.user_value, this.password_value);
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("1", "coffee-1");
            pass = this.beanRef.getEJBObjectTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("2", "coffee-2");
            pass = this.beanRef.getEJBHomeTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("3", "coffee-3");
            pass = this.beanRef.getEJBLocalObjectTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("4", "coffee-4");
            pass = this.beanRef.getCallerPrincipalTest(this.user_value);
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("5", "coffee-5");
            pass = this.beanRef.isCallerInRoleTest(this.role1_value);
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void test5b() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("5b", "coffee-5b");
            pass = this.beanRef.isCallerInRoleTest(this.role2_value);
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test5b failed", e);
        }
        if (pass) {
            throw new EETest.Fault("test5b failed");
        }
    }

    public void test6() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("6", "coffee-6");
            pass = this.beanRef.setRollbackOnlyTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test6 failed");
        }
    }

    public void test7() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("7", "coffee-7");
            pass = this.beanRef.getRollbackOnlyTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test7 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test7 failed");
        }
    }

    public void test8() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("8", "coffee-8");
            this.logMsg("EntityBeans cannot obtain UserTransaction interface");
            pass = this.beanRef.getUserTransactionTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test8 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test8 failed");
        }
    }

    public void test9() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("9", "coffee-9");
            this.logMsg("Obtain primary key");
            pass = this.beanRef.getPrimaryKeyTest("9");
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test9 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test9 failed");
        }
    }

    public void test10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("10", "coffee-10");
            this.logMsg("CMP 2.0 Entity Bean can obtain Timer Service");
            pass = this.beanRef.getTimerServiceTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test10 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test10 failed");
        }
    }

    public void test11() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create("11", "coffee-11");
            pass = this.beanRef.getEJBLocalHomeTest();
            this.beanRef.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("test11 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("test11 failed");
        }
    }

    public void getIt() throws Exception {
        FastPath fastPath = this.getFastPathBean();
        String result = fastPath.getIt("user");
        if (!ENV_ENTRY_VALUE.equals(result)) {
            throw new EETest.Fault("Expecting cts1 from looking up env-entry user, but actaul " + result);
        }
        this.logMsg("Got expected result when looking up env-entry user: " + result);
    }

    public void setIt() throws Exception {
        FastPath fastPath = this.getFastPathBean();
        String result = fastPath.setIt("user");
        if (!ENV_ENTRY_VALUE.equals(result)) {
            throw new EETest.Fault("Expecting cts1 from looking up env-entry user, but actaul " + result);
        }
        this.logMsg("Got expected result when looking up env-entry user: " + result);
    }

    public void getCoffeeId() throws Exception {
        String coffeeId = "coffeeId";
        FastPath fastPath = this.getFastPathBean();
        String result = fastPath.getCoffeeId("coffeeId");
        if (!"coffeeId".equals(result)) {
            throw new EETest.Fault("Expecting coffeeId from calling FastPathBean.getCoffeeId, but actual " + result);
        }
        this.logMsg("Got expected result when calling FastPathBean.getCoffeeId " + result);
    }

    public void setBrandName() throws Exception {
        String oldBrand = "oldBrand";
        String newBrand = "newBrand";
        FastPath fastPath = this.getFastPathBean();
        String result = fastPath.setCoffeeBrand("oldBrand", "newBrand");
        if (!"newBrand".equals(result)) {
            throw new EETest.Fault("Expecting newBrand from calling FastPathBean.setCoffeeBrand, but actual " + result);
        }
        this.logMsg("Got expected result when calling FastPathBean.setCoffeeBrand " + result);
    }

    private FastPath getFastPathBean() throws Exception, CreateException, RemoteException {
        FastPathHome fastPathHome = (FastPathHome)this.nctx.lookup("java:comp/env/ejb/FastPathBean", FastPathHome.class);
        FastPath fastPath = fastPathHome.create();
        return fastPath;
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

