/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.queueMsgHeaders;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class QueueHeaderTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.queueMsgHeaders.QueueHeaderTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        QueueHeaderTests theTests = new QueueHeaderTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        this.logTrace("Results: " + status[index]);
        return retcode;
    }

    public void msgHdrIDQTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        String id = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrIDQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceivedO.getJMSMessageID());
            id = messageReceivedO.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("ObjectMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            this.logTrace("Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceivedM.getJMSMessageID());
            id = messageReceivedM.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("MapMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            this.logTrace("Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceivedB.getJMSMessageID());
            id = messageReceivedB.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("BytesMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            this.logTrace("sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            messageSentS.writeString("Testing...");
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceivedS.getJMSMessageID());
            id = messageReceivedS.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("StreamMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            this.logTrace("sending a TextMessage");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("getJMSMessageID ");
            this.logTrace(" " + messageReceived.getJMSMessageID());
            id = messageReceived.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                this.logMsg("TextMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid JMSMessageID returned from JMSMessageID");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgHdrIDQTest");
        }
    }

    public void msgHdrTimeStampQTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            StreamMessage messageSentS = null;
            BytesMessage messageSentB = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrTimeStampQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            long timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            long timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSentO.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentO.getJMSTimestamp() && timeAfterSend >= messageSentO.getJMSTimestamp()) {
                this.logTrace("ObjectMessage TimeStamp pass");
            } else {
                this.logMsg("Error: invalid timestamp from ObjectMessage");
                pass = false;
            }
            this.logTrace("Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            messageSentM.setString("aString", "value");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSentM.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend > messageSentM.getJMSTimestamp() && timeAfterSend >= messageSentM.getJMSTimestamp()) {
                this.logErr("Error: invalid timestamp from MapMessage");
                pass = false;
            }
            this.logTrace("Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            messageSentB.writeByte(bValue);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSentB.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentB.getJMSTimestamp() && timeAfterSend >= messageSentB.getJMSTimestamp()) {
                this.logTrace("BytesMessage TimeStamp pass");
            } else {
                this.logMsg("Error: invalid timestamp from BytesMessage");
                pass = false;
            }
            this.logTrace("sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            messageSentS.writeString("Testing...");
            this.logTrace("Sending message");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSentS.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentS.getJMSTimestamp() && timeAfterSend >= messageSentS.getJMSTimestamp()) {
                this.logTrace("StreamMessage TimeStamp pass");
            } else {
                this.logMsg("Error: invalid timestamp from StreamMessage");
                pass = false;
            }
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            this.logTrace("sending a TextMessage");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            this.logTrace(" getJMSTimestamp");
            this.logTrace(" " + messageSent.getJMSTimestamp());
            this.logTrace("Time at send is: " + timeBeforeSend);
            this.logTrace("Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend > messageSent.getJMSTimestamp() && timeAfterSend >= messageSent.getJMSTimestamp()) {
                this.logErr("Error: invalid timestamp from TextMessage");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid TimeStamp returned from JMSTimeStamp");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgHdrTimeStampQTest");
        }
    }

    public void msgHdrCorlIdQTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        String jmsCorrelationID = "testCorrelationid";
        String testName = "msgHdrCorlIdQTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.logTrace("Send TextMessage to Queue.");
            messageSent.setJMSCorrelationID(jmsCorrelationID);
            try {
                this.tool.getDefaultQueueSender().send((Message)messageSent);
                messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
                if (messageReceived == null) {
                    this.logErr("messageReceived is null");
                    pass = false;
                } else if (messageReceived.getJMSCorrelationID() == null) {
                    pass = false;
                    this.logErr("TextMessage Error: JMSCorrelationID returned a  null");
                } else if (!messageReceived.getJMSCorrelationID().equals(jmsCorrelationID)) {
                    pass = false;
                    this.logErr("TextMessage Error: JMSCorrelationID is incorrect");
                }
            }
            catch (Exception e) {
                pass = false;
                this.logErr("Unexpected Exception: ", e);
            }
            this.logTrace("Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setJMSCorrelationID(jmsCorrelationID);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSCorrelationID() == null) {
                pass = false;
                this.logErr("MapMessage Error: JMSCorrelationID returned a  null");
            } else if (!messageReceivedM.getJMSCorrelationID().equals(jmsCorrelationID)) {
                pass = false;
                this.logErr("MapMessage Error: JMSCorrelationID is incorrect");
            }
            this.logTrace("Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.setJMSCorrelationID(jmsCorrelationID);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSCorrelationID() == null) {
                pass = false;
                this.logMsg("BytesMessage Error: JMSCorrelationID returned a  null");
            } else if (!messageReceivedB.getJMSCorrelationID().equals(jmsCorrelationID)) {
                pass = false;
                this.logMsg("Byte Message Error: JMSCorrelationID is incorrect");
            }
            this.logTrace("sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.setJMSCorrelationID(jmsCorrelationID);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSCorrelationID() == null) {
                pass = false;
                this.logErr("StreamMessage Error: JMSCorrelationID returned a  null");
            } else if (!messageReceivedS.getJMSCorrelationID().equals(jmsCorrelationID)) {
                pass = false;
                this.logErr("StreamMessage Error: JMSCorrelationID is incorrect");
            }
            this.logTrace("Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrIDQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentO.setJMSCorrelationID(jmsCorrelationID);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSCorrelationID() == null) {
                pass = false;
                this.logMsg("ObjectMessage Error: JMSCorrelationID returned a  null");
            } else if (!messageReceivedO.getJMSCorrelationID().equals(jmsCorrelationID)) {
                pass = false;
                this.logMsg("ObjectMessage Error: JMSCorrelationID is incorrect");
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid JMSCorrelationID returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void msgHdrReplyToQTest() throws EETest.Fault {
        boolean pass = true;
        Queue replyQueue = null;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            this.logTrace("Send Text message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                this.logMsg("ERROR: expected replyto field should have been null for this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSent.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            replyQueue = (Queue)messageReceived.getJMSReplyTo();
            this.logTrace("Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("TextMessage Failed");
                pass = false;
            }
            this.logTrace("Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrReplyToQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                replyQueue = (Queue)messageReceivedO.getJMSReplyTo();
                this.logMsg("ReplyTo is: " + replyQueue.toString());
                this.logMsg("ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSentO.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            replyQueue = (Queue)messageReceivedO.getJMSReplyTo();
            this.logTrace("Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("ObjectMessage ReplyTo Failed");
                pass = false;
            }
            this.logTrace("Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                this.logMsg("ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSentM.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("Received Map message ");
            replyQueue = (Queue)messageReceivedM.getJMSReplyTo();
            this.logTrace("Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("MapMessage ReplyTo Failed");
                pass = false;
            }
            this.logTrace("Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                this.logMsg("ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSentB.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("Received Bytes message ");
            replyQueue = (Queue)messageReceivedB.getJMSReplyTo();
            this.logTrace("Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("BytesMessage ReplyTo Failed");
                pass = false;
            }
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            messageSentS.writeString("Testing...");
            this.logTrace("Sending StreamMessage");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSReplyTo() == null) {
                this.logTrace(" as expected replyto field is null");
            } else {
                replyQueue = (Queue)messageReceivedS.getJMSReplyTo();
                this.logMsg("ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            this.logTrace("Set ReplyTo and resend msg");
            messageSentS.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("Received Stream message ");
            replyQueue = (Queue)messageReceivedS.getJMSReplyTo();
            this.logTrace("Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("StreamMessage ReplyTo Failed");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid Replyto returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgHdrReplyToQTest");
        }
    }

    public void msgHdrJMSTypeQTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        String type = "TESTMSG";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            this.logTrace("JMSType test - Send a TextMessage");
            messageSent.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceived.getJMSType());
            if (messageReceived.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("TextMessage Failed");
                pass = false;
            }
            this.logTrace("JMSType test - Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSTypeQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            messageSentO.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceivedO.getJMSType());
            if (messageReceivedO.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("ObjectMessage JMSType Failed");
                pass = false;
            }
            this.logTrace("JMSType test - Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            messageSentM.setString("aString", "value");
            messageSentM.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceivedM.getJMSType());
            if (messageReceivedM.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("MapMessage JMSType Failed");
                pass = false;
            }
            this.logTrace("JMSType test - Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            messageSentB.writeByte(bValue);
            messageSentB.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceivedB.getJMSType());
            if (messageReceivedB.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("BytesMessage JMSType Failed");
                pass = false;
            }
            this.logTrace("JMSType test - sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            messageSentS.writeString("Testing...");
            messageSentS.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSType is " + messageReceivedS.getJMSType());
            if (messageReceivedS.getJMSType().equals(type)) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("StreamMessage JMSType Failed");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid JMSType returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgHdrJMSTypeQTest");
        }
    }

    public void msgHdrJMSPriorityQTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        int priority = 2;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            this.logTrace("JMSPriority test - Send a TextMessage");
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceived.getJMSPriority());
            if (messageReceived.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("TextMessage Failed");
                pass = false;
            }
            this.logTrace("JMSPriority test - Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSPriorityQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceivedO.getJMSPriority());
            if (messageReceivedO.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("ObjectMessage JMSPriority Failed");
                pass = false;
            }
            this.logTrace("JMSPriority test - Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceivedM.getJMSPriority());
            if (messageReceivedM.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("MapMessage JMSPriority Failed");
                pass = false;
            }
            this.logTrace("JMSPriority test - Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceivedB.getJMSPriority());
            if (messageReceivedB.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("BytesMessage JMSPriority Failed");
                pass = false;
            }
            this.logTrace("JMSPriority test - sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSPriority is " + messageReceivedS.getJMSPriority());
            if (messageReceivedS.getJMSPriority() == priority) {
                this.logTrace("Pass ");
            } else {
                this.logMsg("StreamMessage JMSPriority Failed");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid JMSPriority returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgHdrJMSPriorityQTest");
        }
    }

    public void msgHdrJMSExpirationQueueTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        long forever = 0L;
        long timeToLive = this.timeout;
        String testName = "msgHdrJMSExpirationQueueTest";
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("JMSExpiration test - Send a TextMessage");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSExpiration() != forever) {
                this.logErr("TextMessage Failed");
                pass = false;
            }
            this.logTrace("JMSExpiration test - Send a TextMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            long exp = messageSent.getJMSExpiration();
            TestUtil.logTrace((String)("JMSExpiration is set to=" + exp));
            TestUtil.logTrace((String)("Time before send=" + timeBeforeSend));
            TestUtil.logTrace((String)("Time after send=" + timeAfterSend));
            TestUtil.logTrace((String)("Time to Live =" + timeToLive));
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSExpiration() != exp) {
                TestUtil.logErr((String)("TextMessage Failed: JMSExpiration didnot set correctly = " + messageReceived.getJMSExpiration()));
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            }
            this.logTrace("JMSExpiration test - Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSExpirationQueueTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSExpiration() != forever) {
                this.logMsg("ObjectMessage JMSExpiration Failed");
                pass = false;
            }
            this.logTrace("JMSExpiration test - Send an ObjectMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentO.getJMSExpiration();
            TestUtil.logTrace((String)("JMSExpiration is set to=" + exp));
            TestUtil.logTrace((String)("Time before send=" + timeBeforeSend));
            TestUtil.logTrace((String)("Time after send=" + timeAfterSend));
            TestUtil.logTrace((String)("Time to Live =" + timeToLive));
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSExpiration() != exp) {
                this.logErr("ObjectMessage Failed: JMSExpiration didnot set correctly = " + messageReceivedO.getJMSExpiration());
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            }
            this.logTrace("JMSExpiration test - Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSExpiration() != forever) {
                this.logMsg("MapMessage JMSExpiration Failed");
                pass = false;
            }
            this.logTrace("JMSExpiration test - Send a MapMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentM.getJMSExpiration();
            TestUtil.logTrace((String)("JMSExpiration is set to=" + exp));
            TestUtil.logTrace((String)("Time before send=" + timeBeforeSend));
            TestUtil.logTrace((String)("Time after send=" + timeAfterSend));
            TestUtil.logTrace((String)("Time to Live =" + timeToLive));
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSExpiration() != exp) {
                this.logErr("MapMessage Failed: JMSExpiration didnot set correctly = " + messageReceivedM.getJMSExpiration());
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            }
            this.logTrace("JMSExpiration test - Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSExpiration() != forever) {
                this.logMsg("BytesMessage JMSExpiration Failed");
                pass = false;
            }
            this.logTrace("JMSExpiration test - Send a BytesMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentB.getJMSExpiration();
            TestUtil.logTrace((String)("JMSExpiration is set to=" + exp));
            TestUtil.logTrace((String)("Time before send=" + timeBeforeSend));
            TestUtil.logTrace((String)("Time after send=" + timeAfterSend));
            TestUtil.logTrace((String)("Time to Live =" + timeToLive));
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSExpiration() != exp) {
                this.logErr("BytesMessage Failed: JMSExpiration didnot set correctly = " + messageReceivedB.getJMSExpiration());
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            }
            this.logTrace("JMSExpiration test - sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSExpiration() != forever) {
                this.logMsg("StreamMessage JMSExpiration Failed");
                pass = false;
            }
            this.logTrace("JMSExpiration test - Send a StreamMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentS.getJMSExpiration();
            TestUtil.logTrace((String)("JMSExpiration is set to=" + exp));
            TestUtil.logTrace((String)("Time before send=" + timeBeforeSend));
            TestUtil.logTrace((String)("Time after send=" + timeAfterSend));
            TestUtil.logTrace((String)("Time to Live =" + timeToLive));
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSExpiration() != exp) {
                this.logErr("StreamMessage Failed: JMSExpiration didnot set correctly = " + messageReceivedS.getJMSExpiration());
                TestUtil.logErr((String)("JMSExpiration was set to=" + exp));
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid JMSExpiration returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void msgHdrJMSDestinationQTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        Queue replyDestination = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            this.logTrace("Send TextMessage to Queue.");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceived.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                this.logMsg("TextMessage Error: JMSDestination returned a  null");
            } else {
                this.logTrace("Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    this.logTrace("Pass ");
                } else {
                    this.logMsg("TextMessage Failed");
                    pass = false;
                }
            }
            this.logTrace("Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSDestinationQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceivedO.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                this.logMsg("ObjectMessage Error: JMSDestination returned a  null");
            } else {
                this.logTrace("Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    this.logTrace("Pass ");
                } else {
                    this.logMsg("ObjectMessage Failed");
                    pass = false;
                }
            }
            this.logTrace("Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceivedM.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                this.logMsg("MapMessage Error: JMSDestination returned a  null");
            } else {
                this.logTrace("Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    this.logTrace("Pass ");
                } else {
                    this.logMsg("MapMessage Failed");
                    pass = false;
                }
            }
            this.logTrace("Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceivedB.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                this.logMsg("BytesMessage Error: JMSDestination returned a  null");
            } else {
                this.logTrace("Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    this.logTrace("Pass ");
                } else {
                    this.logMsg("BytesMessage Failed");
                    pass = false;
                }
            }
            this.logTrace("sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            messageSentS.writeString("Testing...");
            this.logTrace("Sending StreamMessage");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logTrace("JMSDestination:  " + messageReceivedS.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                this.logMsg("StreamMessage Error: JMSDestination returned a  null");
            } else {
                this.logTrace("Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    this.logTrace("Pass ");
                } else {
                    this.logMsg("StreamMessage Failed");
                    pass = false;
                }
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid JMSDestination returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgHdrJMSDestinationQTest");
        }
    }

    public void msgHdrJMSDeliveryModeQTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        String testName = "msgHdrJMSDeliveryModeQTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("send TextMessage to Queue.");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logErr("TextMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceived.setJMSDeliveryMode(1);
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("TextMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"Test for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logMsg("ObjectMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceivedO.setJMSDeliveryMode(1);
            if (messageReceivedO.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("ObjectMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logMsg("MapMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceivedM.setJMSDeliveryMode(1);
            if (messageReceivedM.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("MapMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logErr("BytesMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceivedB.setJMSDeliveryMode(1);
            if (messageReceivedB.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("BytesMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logErr("StreamMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceivedS.setJMSDeliveryMode(1);
            if (messageReceivedS.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("StreamMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("send TextMessage to Queue.");
            this.tool.getDefaultQueueSender().setDeliveryMode(1);
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("TextMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceived.setJMSDeliveryMode(2);
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logErr("TextMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSDeliveryModeQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("ObjectMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceivedO.setJMSDeliveryMode(2);
            if (messageReceivedO.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logErr("ObjectMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("MapMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceivedM.setJMSDeliveryMode(2);
            if (messageReceivedM.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logErr("MapMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("BytesMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceivedB.setJMSDeliveryMode(2);
            if (messageReceivedB.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logErr("BytesMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            this.logTrace("sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSDeliveryMode() != 1) {
                pass = false;
                this.logErr("StreamMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceivedS.setJMSDeliveryMode(2);
            if (messageReceivedS.getJMSDeliveryMode() != 2) {
                pass = false;
                this.logErr("StreamMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid JMSDeliveryMode returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }

    public void msgHdrJMSRedeliveredTest() throws EETest.Fault {
        boolean pass = true;
        byte bValue = 127;
        String testName = "msgHdrJMSRedeliveredTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("send TextMessage to Queue.");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSRedelivered()) {
                pass = false;
                this.logErr("TextMessage Error: JMSRedelivered should be false");
            }
            messageReceived.setJMSRedelivered(true);
            if (!messageReceived.getJMSRedelivered()) {
                pass = false;
                this.logErr("TextMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            this.logTrace("send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"Test for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSRedelivered()) {
                pass = false;
                this.logErr("ObjectMessage Error: JMSRedelivered should be false");
            }
            messageReceivedO.setJMSRedelivered(true);
            if (!messageReceivedO.getJMSRedelivered()) {
                pass = false;
                this.logErr("ObjectMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            this.logTrace("send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSRedelivered()) {
                pass = false;
                this.logErr("MapMessage Error: JMSRedelivered should be false");
            }
            messageReceivedM.setJMSRedelivered(true);
            if (!messageReceivedM.getJMSRedelivered()) {
                pass = false;
                this.logErr("MapMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            this.logTrace("send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSRedelivered()) {
                pass = false;
                this.logErr("BytesMessage Error: JMSRedelivered should be false");
            }
            messageReceivedB.setJMSRedelivered(true);
            if (!messageReceivedB.getJMSRedelivered()) {
                pass = false;
                this.logErr("BytesMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            this.logTrace("sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSRedelivered()) {
                pass = false;
                this.logErr("StreamMessage Error: JMSRedelivered should be false");
            }
            messageReceivedS.setJMSRedelivered(true);
            if (!messageReceivedS.getJMSRedelivered()) {
                pass = false;
                this.logErr("StreamMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            if (!pass) {
                throw new EETest.Fault("Error: invalid JMSDeliveryMode returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName);
        }
    }
}

