/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.RegistryPackage;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;

public class JAXRClient
extends JAXRCommonClient {
    BusinessQueryManager bqm = null;

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            super.cleanUpRegistry();
            this.debug.clear();
            this.bqm = this.rs.getBusinessQueryManager();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            super.cleanup();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void registryObjectTest() throws EETest.Fault {
        String testName = "registryObjectTest";
        String serviceName = "testService_registryObjectTest";
        int providerlevel = 0;
        String name = "TestOrganizationName_registryObjectTest";
        int failcount = 0;
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            Service service = this.blm.createService(serviceName);
            RegistryPackage rp = this.blm.createRegistryPackage("registryPackage_registryObjectTest");
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + "failed to throw expected UnsupportedCapabilityException.");
            }
            Key serviceKey = service.getKey();
            rp.addRegistryObject((RegistryObject)service);
            Set ros = rp.getRegistryObjects();
            Iterator iter = ros.iterator();
            Service s = null;
            while (iter.hasNext()) {
                Service myService;
                Object o = iter.next();
                if (!(o instanceof Service) || !(myService = (Service)o).getKey().getId().equals(serviceKey.getId())) continue;
                s = myService;
                this.debug.add("All set, I found my service \n");
                break;
            }
            if (s == null) {
                this.debug.add("Error - my service was not returned from getRegistryObjects\n");
                failcount = 1;
            }
            rp.removeRegistryObject((RegistryObject)service);
            Set regos = rp.getRegistryObjects();
            iter = regos.iterator();
            s = null;
            while (iter.hasNext()) {
                Service myService;
                Object o = iter.next();
                if (!(o instanceof Service) || !(myService = (Service)o).getKey().getId().equals(serviceKey.getId())) continue;
                this.debug.add("Error - my service was not removed with removeRegistryObject \n");
                ++failcount;
            }
            if (failcount > 0) {
                throw new EETest.Fault(testName + " failed - run with trace = true to see specific error.");
            }
        }
        catch (UnsupportedCapabilityException uce) {
            if (providerlevel != 0) {
                TestUtil.logErr((String)("Cleanup error: " + uce.toString()));
                TestUtil.printStackTrace((Throwable)uce);
                throw new EETest.Fault(testName + " failed - unexpected UnsupportedCapabilityException");
            }
        }
        catch (Exception e) {
            if (providerlevel == 0) {
                TestUtil.logErr((String)"Expected level 0 provider to throw UnsupportedCapabilityException");
            }
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }

    public void registryObjectsTest() throws EETest.Fault {
        String testName = "registryObjectsTest";
        String serviceName = "testService_registryObjectsTest";
        int providerlevel = 0;
        String name = "TestOrganizationName_registryObjectsTest";
        int failcount = 0;
        try {
            providerlevel = this.rs.getCapabilityProfile().getCapabilityLevel();
            Organization org = this.blm.createOrganization(this.blm.createInternationalString(name));
            Service service = this.blm.createService(serviceName);
            RegistryPackage rp = this.blm.createRegistryPackage(this.blm.createInternationalString("registryPackage_registryObjectTest"));
            if (providerlevel == 0) {
                throw new EETest.Fault(testName + "failed to throw expected UnsupportedCapabilityException.");
            }
            Key serviceKey = service.getKey();
            Key orgKey = org.getKey();
            this.debug.add("Service key is: " + serviceKey.getId() + "\n");
            this.debug.add("orgKey is: " + orgKey.getId() + "\n");
            ArrayList<Object> robs = new ArrayList<Object>();
            robs.add(service);
            robs.add(org);
            rp.addRegistryObjects(robs);
            Set ros = rp.getRegistryObjects();
            this.debug.add("Number of registry objects returned is " + ros.size() + "\n");
            Iterator iter = ros.iterator();
            Service myService = null;
            Organization myOrg = null;
            boolean count = false;
            while (iter.hasNext()) {
                Object o = iter.next();
                this.debug.add("what is it? " + o.getClass().getName() + "\n");
                if (o instanceof Service) {
                    this.debug.add("getRegistryObjects() returned a service\n");
                    Service s = (Service)o;
                    if (s.getKey().getId().equals(serviceKey.getId())) {
                        this.debug.add("Found my service ! \n");
                        myService = s;
                    }
                }
                if (!(o instanceof Organization)) continue;
                this.debug.add("getRegistryObjects() returned an organization \n");
                Organization orgn = (Organization)o;
                if (!orgn.getKey().getId().equals(orgKey.getId())) continue;
                myOrg = orgn;
                this.debug.add("Found my org! \n");
            }
            if (myService == null) {
                ++failcount;
                this.debug.add("Error - getRegistryObjects() did not return my service \n");
            }
            if (myOrg == null) {
                ++failcount;
                this.debug.add("Error - getRegistryObjects() did not return my organization \n");
            }
            rp.removeRegistryObjects(robs);
            Set regos = rp.getRegistryObjects();
            for (Object o : regos) {
                Organization orgn;
                Service s;
                if (o instanceof Service && (s = (Service)o).getKey().getId().equals(serviceKey.getId())) {
                    ++failcount;
                    this.debug.add("Error - my service was not removed with removeRegistryObjects \n");
                }
                if (!(o instanceof Organization) || !(orgn = (Organization)o).getKey().getId().equals(orgKey.getId())) continue;
                ++failcount;
                this.debug.add("Error - my organization was not removed with removeRegistryObjects \n");
            }
            if (failcount > 0) {
                throw new EETest.Fault(testName + " failed ");
            }
        }
        catch (UnsupportedCapabilityException uce) {
            if (providerlevel != 0) {
                TestUtil.logErr((String)("Cleanup error: " + uce.toString()));
                TestUtil.printStackTrace((Throwable)uce);
                throw new EETest.Fault(testName + " failed - unexpected UnsupportedCapabilityException");
            }
        }
        catch (Exception e) {
            if (providerlevel == 0) {
                TestUtil.logErr((String)"Expected level 0 provider to throw UnsupportedCapabilityException");
            }
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed ");
        }
    }
}

