/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry_infomodel.ExternalLink;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Organization;

public class JAXRClient
extends JAXRCommonClient {
    Locale tsLocale = new Locale("en", "US");

    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void externalLink_getExternalURITest() throws EETest.Fault {
        String testName = "externalLink_getExternalURITest";
        String externalURI = this.baseuri + "jaxrTestPage1.html";
        String description = "JAXR test page";
        boolean pass = false;
        try {
            ExternalLink el = this.blm.createExternalLink(externalURI, description);
            String ret = el.getExternalURI();
            this.debug.add("getExternalURI returned " + ret + "\n");
            if (ret.equals(externalURI)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void externalLink_setExternalURITest() throws EETest.Fault {
        String testName = "externalLink_setExternalURITest";
        String createURI = this.baseuri + "jaxrTestPage1.html";
        String externalURI = this.baseuri + "jaxrTestPage2.html";
        String description = "JAXR test page";
        boolean pass = false;
        try {
            ExternalLink el = this.blm.createExternalLink(createURI, description);
            el.setExternalURI(externalURI);
            String ret = el.getExternalURI();
            this.debug.add("getExternalURI returned " + ret + "\n");
            if (ret.equals(externalURI)) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void externalLink_getLinkedObjectsEmptyTest() throws EETest.Fault {
        String testName = "externalLink_getLinkedObjectsEmptyTest";
        String externalURI = this.baseuri + "jaxrTestPage1.html";
        String description = "JAXR test page";
        boolean pass = false;
        try {
            ExternalLink el = this.blm.createExternalLink(externalURI, description);
            Collection c = el.getLinkedObjects();
            if (c.size() == 0) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void externalLink_getLinkedObjectsTest() throws EETest.Fault {
        String testName = "externalLink_getLinkedObjectsTest";
        String externalURI = this.baseuri + "jaxrTestPage1.html";
        String description = this.baseuri + "jaxrTestPage2.html";
        String testOrg = "TestOrganization";
        boolean pass = false;
        try {
            ExternalLink el = this.blm.createExternalLink(externalURI, description);
            InternationalString itestOrg = this.blm.createInternationalString(this.tsLocale, testOrg);
            Organization org = this.blm.createOrganization(itestOrg);
            org.addExternalLink(el);
            Collection c = el.getLinkedObjects();
            Iterator iter = c.iterator();
            if (c.size() == 1) {
                while (iter.hasNext()) {
                    Organization o = (Organization)iter.next();
                    if (!o.getName().getValue(this.tsLocale).equals(testOrg)) continue;
                    pass = true;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void externalLink_invalidURITest() throws EETest.Fault {
        String testName = "externalLink_invalidURITest";
        boolean pass = true;
        String uriDescription = "pass an invalid URI";
        String invalidURI = "this is not a valid uri";
        try {
            ExternalLink el = this.blm.createExternalLink(invalidURI, uriDescription);
            this.debug.add("Error: InvalidRequestException not thrown as expected\n");
            pass = false;
        }
        catch (InvalidRequestException ire) {
            TestUtil.printStackTrace((Throwable)ire);
            this.debug.add("Good: InvalidRequestException was thrown as expected\n");
        }
        catch (Exception ue) {
            this.debug.add("Error: InvalidRequestException not thrown as expected\n");
            TestUtil.logErr((String)("Caught exception: " + ue.getMessage()));
            pass = false;
            TestUtil.printStackTrace((Throwable)ue);
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }
}

