/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.customizedmapping.binarydata;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.customizedmapping.binarydata.model.BinaryDataContainer;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;

public class BinaryDataCustomizationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;

    public static void main(String[] args) {
        BinaryDataCustomizationTest t = new BinaryDataCustomizationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testByteBinaryDataEncoding() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withBinaryDataStrategy("BYTE"));
        String jsonString = jsonb.toJson((Object)new BinaryDataContainer());
        if (!jsonString.matches("\\{\\s*\"data\"\\s*:\\s*\\[\\s*84\\s*,\\s*101\\s*,\\s*115\\s*,\\s*116\\s*,\\s*32\\s*,\\s*83\\s*,\\s*116\\s*,\\s*114\\s*,\\s*105\\s*,\\s*110\\s*,\\s*103\\s*]\\s*}")) {
            throw new EETest.Fault("Failed to correctly marshal binary data using BYTE binary data encoding.");
        }
        BinaryDataContainer unmarshalledObject = (BinaryDataContainer)jsonb.fromJson("{ \"data\" : [ 84, 101, 115, 116, 32, 83, 116, 114, 105, 110, 103 ] }", BinaryDataContainer.class);
        if (!"Test String".equals(new String(unmarshalledObject.getData()))) {
            throw new EETest.Fault("Failed to correctly unmarshal binary data using BYTE binary data encoding.");
        }
        return Status.passed((String)"OK");
    }

    public Status testBase64BinaryDataEncoding() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withBinaryDataStrategy("BASE_64"));
        String jsonString = jsonb.toJson((Object)new BinaryDataContainer());
        if (!jsonString.matches("\\{\\s*\"data\"\\s*:\\s*\"VGVzdCBTdHJpbmc=\"\\s*}")) {
            throw new EETest.Fault("Failed to correctly marshal binary data using BASE_64 binary data encoding.");
        }
        BinaryDataContainer unmarshalledObject = (BinaryDataContainer)jsonb.fromJson("{ \"data\" : \"VGVzdCBTdHJpbmc\" }", BinaryDataContainer.class);
        if (!"Test String".equals(new String(unmarshalledObject.getData()))) {
            throw new EETest.Fault("Failed to correctly unmarshal binary data using BASE_64 binary data encoding.");
        }
        return Status.passed((String)"OK");
    }

    public Status testBase64UrlBinaryDataEncoding() throws EETest.Fault {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withBinaryDataStrategy("BASE_64_URL"));
        String jsonString = jsonb.toJson((Object)new BinaryDataContainer());
        if (!jsonString.matches("\\{\\s*\"data\"\\s*:\\s*\"VGVzdCBTdHJpbmc=\"\\s*}")) {
            throw new EETest.Fault("Failed to correctly marshal binary data using BASE_64_URL binary data encoding.");
        }
        BinaryDataContainer unmarshalledObject = (BinaryDataContainer)jsonb.fromJson("{ \"data\" : \"VGVzdCBTdHJpbmc=\" }", BinaryDataContainer.class);
        if (!"Test String".equals(new String(unmarshalledObject.getData()))) {
            throw new EETest.Fault("Failed to correctly unmarshal binary data using BASE_64_URL binary data encoding.");
        }
        return Status.passed((String)"OK");
    }
}

