/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.stateful.concurrency.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.lite.EJBLiteClientBase;
import com.sun.ts.tests.ejb30.lite.stateful.concurrency.common.Pinger;
import com.sun.ts.tests.ejb30.lite.stateful.concurrency.common.StatefulConcurrencyIF;
import java.util.List;
import java.util.logging.Level;
import javax.ejb.ConcurrentAccessException;

public abstract class StatefulConcurrencyClientBase
extends EJBLiteClientBase {
    protected List<Exception> concurrentPing(StatefulConcurrencyIF b) throws InterruptedException {
        Pinger[] pingers = new Pinger[2];
        for (int i = 0; i < 2; ++i) {
            pingers[i] = new Pinger(b);
        }
        return this.concurrentPing0(pingers);
    }

    protected List<Exception> concurrentPing(Runnable runnable) throws InterruptedException {
        Pinger[] pingers = new Pinger[2];
        for (int i = 0; i < 2; ++i) {
            pingers[i] = new Pinger(runnable);
        }
        return this.concurrentPing0(pingers);
    }

    private List<Exception> concurrentPing0(Pinger[] pingers) throws InterruptedException {
        for (Pinger p : pingers) {
            p.start();
        }
        for (Pinger p : pingers) {
            try {
                p.join();
            }
            catch (InterruptedException e) {
                Helper.getLogger().log(Level.WARNING, null, e);
            }
        }
        return Pinger.getExceptionAsList(pingers);
    }

    protected void checkConcurrentAccessResult(List<Exception> exceptionList, int nullCountExpected, int concurrentAccessExceptionCountExpected) {
        int nullCount = 0;
        int concurrentAccessExceptionCount = 0;
        Helper.getLogger().fine("exceptionList: " + exceptionList.toString());
        for (Exception e : exceptionList) {
            if (e == null) {
                this.appendReason("Got no exception, which may be correct.");
                ++nullCount;
                continue;
            }
            if (e instanceof ConcurrentAccessException) {
                this.appendReason("Got ConcurrentAccessException, which may be correct: ", e);
                ++concurrentAccessExceptionCount;
                continue;
            }
            throw new RuntimeException("Expecting null or ConcurrentAccessException, but got ", e);
        }
        this.assertEquals("Check nullCount", nullCountExpected, nullCount);
        this.assertEquals("Check concurrentAccessExceptionCount", concurrentAccessExceptionCountExpected, concurrentAccessExceptionCount);
    }
}

