/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.validation;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.parser.CompoundSecMechEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORASContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IOREntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORSASContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.IORTransportMechEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.TransportAddressEntry;
import com.sun.ts.tests.interop.csiv2.common.validation.GSSUtils;
import com.sun.ts.tests.interop.csiv2.common.validation.OutputLog;
import com.sun.ts.tests.interop.csiv2.common.validation.ValidationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class IORValidationStrategy {
    protected OutputLog log = new OutputLog();
    protected static final int NO_PROTECTION = 1;
    protected static final int INTEGRITY = 2;
    protected static final int CONFIDENTIALITY = 4;
    protected static final int DETECT_REPLAY = 8;
    protected static final int DETECT_MISORDERING = 16;
    protected static final int ESTABLISH_TRUST_IN_TARGET = 32;
    protected static final int ESTABLISH_TRUST_IN_CLIENT = 64;
    protected static final int NO_DELEGATION = 128;
    protected static final int SIMPLE_DELEGATION = 256;
    protected static final int COMPOSITE_DELEGATION = 512;
    protected static final int IDENTITY_ASSERTION = 1024;
    protected static final int DELEGATION_BY_CLIENT = 2048;
    public static final int ITTAbsent = 0;
    public static final int ITTAnonymous = 1;
    public static final int ITTPrincipalName = 2;
    public static final int ITTX509CertChain = 4;
    public static final int ITTDistinguishedName = 8;
    private static final String printLine = "-------------------------------------------";
    private static final Hashtable<Integer, String> assocOptions = new Hashtable();
    private static final Hashtable<Integer, String> identityTokenTypes;

    protected String getTargetOptions(int requiresOrSupports) {
        StringBuffer strbuf = new StringBuffer();
        Enumeration<Integer> keys = assocOptions.keys();
        while (keys.hasMoreElements()) {
            Integer j = keys.nextElement();
            if (!IORValidationStrategy.isSet(requiresOrSupports, j)) continue;
            strbuf.append(assocOptions.get(j) + " ");
        }
        return strbuf.toString();
    }

    protected String getSupportedIdentityTypes(int identityTokenType) {
        StringBuffer strbuf = new StringBuffer();
        long map = identityTokenType;
        Enumeration<Integer> keys = identityTokenTypes.keys();
        while (keys.hasMoreElements()) {
            Integer j = keys.nextElement();
            if (!IORValidationStrategy.isSet(identityTokenType, j)) continue;
            strbuf.append(identityTokenTypes.get(j) + " ");
            map -= (long)j.intValue();
        }
        if (map > 0L) {
            strbuf.append("custom bits set: " + map);
        }
        return strbuf.toString();
    }

    public boolean validate(IOREntry ior) throws ValidationException {
        boolean result = true;
        this.log.logInfo("Validating received IOR against " + this.getName());
        TestUtil.logTrace((String)(ior.toString() + printLine));
        boolean valid = this.verifyIIOPProfilePort(ior.getPort());
        boolean bl = result = result && valid;
        if (!valid) {
            this.log.logMismatch("Mismatched IIOPProfile port.");
        }
        Vector compoundSecMechs = ior.getCompoundSecMechs();
        boolean atLeastOneCorrect = false;
        for (int i = 0; i < compoundSecMechs.size(); ++i) {
            this.log.logInfo("Testing CompoundSecMech " + (i + 1) + " of " + compoundSecMechs.size() + "...");
            CompoundSecMechEntry mech = (CompoundSecMechEntry)compoundSecMechs.elementAt(i);
            valid = this.isValid(mech);
            boolean bl2 = atLeastOneCorrect = atLeastOneCorrect || valid;
            if (valid) {
                this.log.logMatch("This CompoundSecMech matches " + this.getName());
                continue;
            }
            this.log.logMismatch("This CompoundSecMech does not match " + this.getName());
        }
        if (atLeastOneCorrect) {
            this.log.logMatch("At least one compound sec mech matched " + this.getName() + ".");
        } else {
            this.log.logMismatch("None of the compound sec mechs matched " + this.getName() + ".");
        }
        result = result && atLeastOneCorrect;
        return result;
    }

    private boolean isValid(CompoundSecMechEntry mech) throws ValidationException {
        boolean result = true;
        boolean valid = this.verifyTargetRequires(mech.getTargetRequires());
        if (!valid) {
            this.log.logMismatch("Mismatch on target requires.");
        }
        result = result && valid;
        IORTransportMechEntry iorTransportMech = mech.getIorTransportMech();
        if (iorTransportMech == null) {
            throw new ValidationException("No IOR Transport mech found.");
        }
        valid = this.verifyIORTransportMech(iorTransportMech);
        if (!valid) {
            this.log.logMismatch("Mismatch on IOR Transport Mech");
        }
        result = result && valid;
        IORASContextEntry iorASContext = mech.getIorASContext();
        if (iorASContext == null) {
            throw new ValidationException("No IOR ASContext found.");
        }
        valid = this.verifyASContext(iorASContext);
        if (!valid) {
            this.log.logMismatch("Mismatch on AS Context");
        }
        result = result && valid;
        IORSASContextEntry iorSASContext = mech.getIorSASContext();
        if (iorSASContext == null) {
            throw new ValidationException("No IOR SASContext found.");
        }
        valid = this.verifySASContext(mech.getIorSASContext());
        if (!valid) {
            this.log.logMismatch("Mismatch on SAS Context");
        }
        result = result && valid;
        return result;
    }

    public boolean atLeastOneValidAddr(Vector transAddrs) throws ValidationException {
        boolean atLeastOneValid = false;
        for (int i = 0; i < transAddrs.size(); ++i) {
            this.log.logInfo("Testing Transport Address " + (i + 1) + " of " + transAddrs.size() + "...");
            TransportAddressEntry addr = (TransportAddressEntry)transAddrs.elementAt(i);
            boolean valid = this.isValidAddr(addr);
            boolean bl = atLeastOneValid = atLeastOneValid || valid;
            if (valid) {
                this.log.logMatch("This transport address matches " + this.getName());
                continue;
            }
            this.log.logMismatch("This transport address does not match " + this.getName());
        }
        if (atLeastOneValid) {
            this.log.logMatch("At least one transport address matched " + this.getName() + ".");
        } else {
            this.log.logMismatch("None of the transport address  matched " + this.getName() + ".");
        }
        return atLeastOneValid;
    }

    private boolean isValidAddr(TransportAddressEntry addr) throws ValidationException {
        int port;
        boolean result = true;
        String hostname = addr.getHostname();
        if (hostname == null || hostname.trim().length() == 0) {
            result = false;
            this.log.logMismatch("Mismatch on hostname.");
        }
        if ((port = addr.getPort()) == 0) {
            result = false;
            this.log.logMismatch("Mismatch on port.");
        }
        return result;
    }

    public boolean atLeastOneValidNamingMech(Vector mechs) throws ValidationException {
        boolean atLeastOneValid = false;
        for (int i = 0; i < mechs.size(); ++i) {
            this.log.logInfo("Testing Naming Mechanisms " + (i + 1) + " of " + mechs.size() + "...");
            byte[] mech = (byte[])mechs.elementAt(i);
            boolean valid = this.isValidNamingMech(mech);
            boolean bl = atLeastOneValid = atLeastOneValid || valid;
            if (valid) {
                this.log.logMatch("This naming mechanism matches " + this.getName());
                continue;
            }
            this.log.logMismatch("This naming mechanisms does not match " + this.getName());
        }
        if (atLeastOneValid) {
            this.log.logMatch("At least one naming mechanism matched " + this.getName() + ".");
        } else {
            this.log.logMismatch("None of the naming mechanisms  matched " + this.getName() + ".");
        }
        return atLeastOneValid;
    }

    private boolean isValidNamingMech(byte[] namingMech) throws ValidationException {
        boolean result = true;
        try {
            long[] namingMechComponents = GSSUtils.extractComponentsFromOID(namingMech, 0);
            String namingMechString = GSSUtils.formatComponents(namingMechComponents);
            boolean verify = namingMechString.equals("oid:2.23.130.1.1.1");
            if (!verify) {
                this.log.logMismatch("Naming-mech does not verify: Got " + namingMechString + "  Expected: " + "oid:2.23.130.1.1.1");
            }
            result = result && verify;
        }
        catch (GSSUtils.GSSUtilsException e) {
            TestUtil.printStackTrace((Throwable)e);
            this.log.logMismatch("Error verifying auth-mech: " + e);
            result = false;
        }
        return result;
    }

    private static boolean isSet(int val1, int val2) {
        return (val1 & val2) == val2;
    }

    public abstract String getName();

    public abstract boolean verifyIIOPProfilePort(int var1) throws ValidationException;

    public abstract boolean verifyTargetRequires(int var1) throws ValidationException;

    public abstract boolean verifyIORTransportMech(IORTransportMechEntry var1) throws ValidationException;

    public abstract boolean verifyASContext(IORASContextEntry var1) throws ValidationException;

    public abstract boolean verifySASContext(IORSASContextEntry var1) throws ValidationException;

    static {
        assocOptions.put(1, "NO_PROTECTION");
        assocOptions.put(2, "INTEGRITY");
        assocOptions.put(4, "CONFIDENTIALITY");
        assocOptions.put(32, "ESTABLISH_TRUST_IN_TARGET");
        assocOptions.put(64, "ESTABLISH_TRUST_IN_CLIENT");
        assocOptions.put(1024, "IDENTITY_ASSERTION");
        assocOptions.put(2048, "DELEGATION_BY_CLIENT");
        identityTokenTypes = new Hashtable();
        identityTokenTypes.put(0, "Absent");
        identityTokenTypes.put(1, "Anonymous");
        identityTokenTypes.put(2, "PrincipalName");
        identityTokenTypes.put(4, "X509CertChain");
        identityTokenTypes.put(8, "DistinguishedName");
    }
}

