/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.invalidDest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.InvalidDestinationException;
import javax.jms.Session;
import javax.jms.Topic;

public class InvalidDestTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.invalidDest.InvalidDestTests";
    private static final String testDir = System.getProperty("user.dir");
    private static JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;

    public static void main(String[] args) {
        InvalidDestTests theTests = new InvalidDestTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
    }

    public void invalidDestinationTests() throws EETest.Fault {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            boolean pass = true;
            Topic dummyT = null;
            JmsTool tool = new JmsTool(14, this.user, this.password, lookup, this.mode);
            tool.getDefaultConnection().close();
            Connection newConn = tool.getNewConnection(14, this.user, this.password, lookup);
            if (newConn.getClientID() == null) {
                newConn.setClientID("cts");
            }
            Session newSession = newConn.createSession(false, 1);
            try {
                newSession.unsubscribe("foo");
                this.logErr("Error: unsubscribe(foo) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from unsubscribe(foo)");
            }
            catch (Exception e) {
                this.logErr("Error: unsubscribe(foo) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                newSession.createDurableSubscriber(dummyT, "cts");
                this.logErr("Error: createDurableSubscriber(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createDurableSubscriber(null, String)");
            }
            catch (Exception e) {
                this.logErr("Error: createDurableSubscriber(null, String) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                newSession.createDurableSubscriber(dummyT, "cts", "TEST = 'test'", true);
                this.logErr("Error: createDurableSubscriber(null, String, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                this.logMsg("Got expected InvalidDestinationException from createDurableSubscriber(null, String, String, boolean)");
            }
            catch (Exception e) {
                this.logErr("Error: createDurableSubscriber(null, String, String, boolean) throw incorrect Exception: ", e);
                pass = false;
            }
            try {
                newConn.close();
            }
            catch (Exception ex) {
                this.logErr("Error closing new Connection", ex);
            }
            if (!pass) {
                throw new EETest.Fault("invalidDestinationTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("invalidDestinationTests");
        }
    }
}

