/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.stateful.mdb;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.stateful.mdb.Test;
import com.sun.ts.tests.ejb.ee.sec.stateful.mdb.TestHome;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;

public class MsgBean
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private static final String ejbname = "java:comp/env/ejb/Test";
    private static TestHome ejbhome = null;
    private static Test ejbref = null;

    public MsgBean() {
        TestUtil.logTrace((String)"@MsgBean()!");
    }

    public void ejbCreate() throws RemoteException {
        TestUtil.logTrace((String)"@MsgBean-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logTrace((String)"qFactory error");
            }
            TestUtil.logTrace((String)"got a qFactory !!");
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queue == null) {
                TestUtil.logTrace((String)"queue error");
            }
            TestUtil.logTrace((String)"got  a queue ");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoteException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        TestUtil.logTrace((String)("@MsgBean() onMessage! Message " + msg));
        try {
            if (msg.getObjectProperty("properties") != null) {
                this.initLogging((Properties)msg.getObjectProperty("properties"));
            }
            this.qConnection = this.qFactory.createQueueConnection();
            this.qSession = this.qConnection.createQueueSession(false, 0);
            TestUtil.logTrace((String)"@MsgBean() onMessage! createing naming context");
            this.context = new TSNamingContext();
            TestUtil.logTrace((String)("@MsgBean() onMessage! Looking up the ejb home " + this.context));
            ejbhome = (TestHome)this.context.lookup(ejbname, TestHome.class);
            TestUtil.logTrace((String)("@MsgBean() onMessage! got home" + ejbhome));
            if (msg.getStringProperty("MessageType").equals("TextMessage")) {
                ejbref = ejbhome.create();
                TestUtil.logTrace((String)("@MsgBean() onMessage! got ejb object" + ejbref));
                TestUtil.logTrace((String)"@MsgBean() onMessage! It is a TextMessage");
                if (ejbref.EjbIsAuthz()) {
                    this.sendATextMessage();
                } else {
                    this.sendABytesMessage();
                }
            } else if (msg.getStringProperty("MessageType").equals("BytesMessage")) {
                ejbref = ejbhome.create();
                TestUtil.logTrace((String)("@MsgBean() onMessage! got ejb object" + ejbref));
                TestUtil.logTrace((String)"@MsgBean() onMessage! It is a BytesMessage");
                try {
                    ejbref.EjbNotAuthz();
                    this.sendABytesMessage();
                }
                catch (Exception ex) {
                    TestUtil.logMsg((String)("@OnMessage!  Got expected exception: " + ex.getMessage()));
                    this.sendATextMessage();
                }
            } else if (msg.getStringProperty("MessageType").equals("ObjectMessage")) {
                TestUtil.logTrace((String)"@MsgBean() onMessage! It is an ObjectMessage");
                TestUtil.logTrace((String)"Remove test stateful session bean");
                if (ejbref != null) {
                    try {
                        ejbref.remove();
                    }
                    catch (Exception ex) {
                        TestUtil.logErr((String)"Error removing stateful session bean", (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)"@MsgBean() onMessage! Got exception:");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void initLogging(Properties p) throws RemoteException {
        try {
            TestUtil.init((Properties)p);
            TestUtil.logTrace((String)"MsgBean initLogging OK.");
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"MsgBean initLogging failed.");
            throw new RemoteException(e.getMessage());
        }
    }

    private void sendATextMessage() {
        TestUtil.logTrace((String)"@sendATextMessage");
        try {
            String myMsg = "I am sending a text message as requested";
            this.mSender = this.qSession.createSender(this.queue);
            TextMessage msg = this.qSession.createTextMessage();
            msg.setText(myMsg);
            msg.setStringProperty("MessageType", "TextMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void sendABytesMessage() {
        TestUtil.logTrace((String)"@sendABytesMessage");
        try {
            byte aByte = 10;
            this.mSender = this.qSession.createSender(this.queue);
            BytesMessage msg = this.qSession.createBytesMessage();
            msg.writeByte(aByte);
            msg.setStringProperty("MessageType", "BytesMessageFromMsgBean");
            this.mSender.send((Message)msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"In MsgBean::remove()!!");
    }
}

