/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.j2w.rpc.literal.R1000;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.sharedclients.faultclient.FaultTestClient;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.ts.tests.jaxrpc.wsi.utils.SOAPUtils;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class Client
extends ServiceEETest
implements SOAPRequests {
    private FaultTestClient client;

    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client = (FaultTestClient)ClientFactory.getClient(FaultTestClient.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testSoapFaultChildrenDummyException() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?> <!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --><env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://faulttestservice.org/wsdl' xmlns:ns1='http://faulttestservice.org/types'><env:Body><ns0:alwaysThrowsException/></env:Body></env:Envelope>");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateFaultChildrenNames(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
        this.client.logMessageInHarness(response);
    }

    public void testSoapFaultChildrenServerException() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?> <!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --> <env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://faulttestservice.org/wsdl' xmlns:ns1='http://faulttestservice.org/types'><env:Body><ns0:alwaysThrowsServerException/></env:Body></env:Envelope>");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateFaultChildrenNames(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
        this.client.logMessageInHarness(response);
    }

    private void validateFaultChildrenNames(SOAPMessage response) throws EETest.Fault, SOAPException {
        Iterator children = response.getSOAPPart().getEnvelope().getBody().getFault().getChildElements();
        while (children.hasNext()) {
            SOAPElement child = (SOAPElement)children.next();
            if (SOAPUtils.isValidSoapFaultChildName(child)) continue;
            this.client.logMessageInHarness(response);
            throw new EETest.Fault("Invalid soap:Fault child name (BP-R1000): " + child.getElementName().getLocalName());
        }
    }
}

