/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jsonb.MappingTester;
import com.sun.ts.tests.jsonb.TypeContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class SimpleMappingTester<T> {
    private final Jsonb jsonb = JsonbBuilder.create();
    private final Class<T> typeClass;

    public SimpleMappingTester(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public Status test(T value, String expectedRepresentationPattern, String expectedRepresentation, Object expectedOutput) throws EETest.Fault {
        return MappingTester.combine(this.testMarshalling(value, expectedRepresentationPattern), this.testMarshallingToStream(value, expectedRepresentationPattern), this.testMarshallingToWriter(value, expectedRepresentationPattern), this.testMarshallingByType(value, expectedRepresentationPattern), this.testMarshallingByTypeToStream(value, expectedRepresentationPattern), this.testMarshallingByTypeToWriter(value, expectedRepresentationPattern), this.testUnmarshallingByClass(expectedRepresentation, expectedOutput), this.testUnmarshallingByClassFromStream(expectedRepresentation, expectedOutput), this.testUnmarshallingByClassFromReader(expectedRepresentation, expectedOutput), this.testUnmarshallingByType(expectedRepresentation, expectedOutput), this.testUnmarshallingByTypeFromStream(expectedRepresentation, expectedOutput), this.testUnmarshallingByTypeFromReader(expectedRepresentation, expectedOutput));
    }

    private Status testMarshalling(T value, String expectedRepresentation) {
        String jsonString = this.jsonb.toJson(value);
        if (jsonString.matches(expectedRepresentation)) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)("[testMarshalling] - Failed to correctly marshal " + value.getClass().getName() + " object"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status testMarshallingToStream(T value, String expectedRepresentation) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson(value, (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            if (jsonString.matches(expectedRepresentation)) {
                Status status2 = Status.passed((String)"OK");
                return status2;
            }
            Status status = Status.failed((String)("[testMarshallingToStream] - Failed to correctly marshal " + value.getClass().getName() + " object"));
            return status;
        }
        catch (IOException e) {
            return Status.error((String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private Status testMarshallingToWriter(T value, String expectedRepresentation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Status testMarshallingByType(T value, String expectedRepresentation) {
        String jsonString = this.jsonb.toJson(value, TypeContainer.class);
        if (jsonString.matches(expectedRepresentation)) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)("[testMarshallingByType] - Failed to correctly marshal " + value.getClass().getName() + " object"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status testMarshallingByTypeToStream(T value, String expectedRepresentation) {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson(value, TypeContainer.class, (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            if (jsonString.matches(expectedRepresentation)) {
                Status status2 = Status.passed((String)"OK");
                return status2;
            }
            Status status = Status.failed((String)("[testMarshallingByTypeToStream] - Failed to correctly marshal " + value.getClass().getName() + " object"));
            return status;
        }
        catch (IOException e) {
            return Status.error((String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private Status testMarshallingByTypeToWriter(T value, String expectedRepresentation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Status testUnmarshallingByClass(String expectedRepresentation, Object value) {
        Object unmarshalledObject = this.jsonb.fromJson(expectedRepresentation, this.typeClass);
        if (value.equals(unmarshalledObject)) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)("[testUnmarshallingByClass] - Failed to correctly unmarshal " + value.getClass().getName() + " object"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status testUnmarshallingByClassFromStream(String expectedRepresentation, Object value) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(expectedRepresentation.getBytes(StandardCharsets.UTF_8));){
            Object unmarshalledObject = this.jsonb.fromJson((InputStream)stream, this.typeClass);
            if (value.equals(unmarshalledObject)) {
                Status status2 = Status.passed((String)"OK");
                return status2;
            }
            Status status = Status.failed((String)("[testUnmarshallingByClassFromStream] - Failed to correctly unmarshal " + value.getClass().getName() + " object"));
            return status;
        }
        catch (IOException e) {
            return Status.error((String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private Status testUnmarshallingByClassFromReader(String expectedRepresentation, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Status testUnmarshallingByType(String expectedRepresentation, Object value) {
        Object unmarshalledObject = this.jsonb.fromJson(expectedRepresentation, this.typeClass);
        if (value.equals(unmarshalledObject)) {
            return Status.passed((String)"OK");
        }
        return Status.failed((String)("[testUnmarshallingByType] - Failed to correctly unmarshal " + value.getClass().getName() + " object"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status testUnmarshallingByTypeFromStream(String expectedRepresentation, Object value) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(expectedRepresentation.getBytes(StandardCharsets.UTF_8));){
            Object unmarshalledObject = this.jsonb.fromJson((InputStream)stream, this.typeClass);
            if (value.equals(unmarshalledObject)) {
                Status status2 = Status.passed((String)"OK");
                return status2;
            }
            Status status = Status.failed((String)("[testUnmarshallingByTypeFromStream] - Failed to correctly unmarshal " + value.getClass().getName() + " object"));
            return status;
        }
        catch (IOException e) {
            return Status.error((String)e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    private Status testUnmarshallingByTypeFromReader(String expectedRepresentation, Object value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

