/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.j2w.rpc.literal.R0006;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.sharedclients.simpleclient.SimpleTestClient;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import java.util.Properties;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class Client
extends ServiceEETest
implements SOAPRequests {
    private SimpleTestClient client;

    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client = (SimpleTestClient)ClientFactory.getClient(SimpleTestClient.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testMultipleConformanceClaimInRequestMessage() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?> <!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --> <env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'> <env:Header> <wsi:Claim conformsTo='http://ws-i.org/profiles/basic1.0/' xmlns:wsi='http://ws-i.org/schemas/conformanceClaim/' /><wsi:Claim conformsTo='http://dummy/conformanceClaim' xmlns:wsi='http://ws-i.org/schemas/conformanceClaim/' /></env:Header><env:Body><ns0:helloWorld/></env:Body></env:Envelope>");
        }
        catch (Exception e) {
            this.client.logMessageInHarness(response);
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.client.logMessageInHarness(response);
            this.validateIsExpected(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
    }

    public void testMultipleConformanceClaimInResponseMessage() throws EETest.Fault {
        String response;
        try {
            response = this.client.helloWorld();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        if (response == null || !response.equals("hello world")) {
            throw new EETest.Fault("Client stub did not properly process response: it must accept messages with conformance claims (BP-R0006)");
        }
    }

    private void validateIsExpected(SOAPMessage response) throws EETest.Fault, SOAPException {
        if (response.getSOAPPart().getEnvelope().getBody().hasFault()) {
            throw new EETest.Fault("Invalid response: instances must accept messageswith multiple conformance claims (BP-R0006)");
        }
        if (!this.getResponseValue(response).equals("hello world")) {
            throw new EETest.Fault("Invalid response: instances must accept messageswith multiple conformance claims (BP-R0006)");
        }
    }

    private String getResponseValue(SOAPMessage response) throws SOAPException {
        SOAPElement elem = (SOAPElement)response.getSOAPPart().getEnvelope().getBody().getChildElements().next();
        return ((SOAPElement)elem.getChildElements().next()).getValue();
    }
}

