/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.jpa22.repeatable.attroverride;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.jpa22.repeatable.attroverride.FullTimeEmployee;
import com.sun.ts.tests.jpa.jpa22.repeatable.attroverride.PartTimeEmployee;
import java.sql.Date;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;
    private static FullTimeEmployee[] ftRef = new FullTimeEmployee[5];
    private static PartTimeEmployee[] ptRef = new PartTimeEmployee[5];
    private final Date d1 = this.getSQLDate(2000, 2, 14);
    private final Date d2 = this.getSQLDate(2001, 6, 27);
    private final Date d3 = this.getSQLDate(2002, 7, 7);
    private final Date d4 = this.getSQLDate(2003, 3, 3);
    private final Date d5 = this.getSQLDate(2004, 4, 10);
    private final Date d6 = this.getSQLDate(2005, 2, 18);
    private final Date d7 = this.getSQLDate(2000, 9, 17);
    private final Date d8 = this.getSQLDate(2001, 11, 14);
    private final Date d9 = this.getSQLDate(2002, 10, 4);
    private final Date d10 = this.getSQLDate(2003, 1, 25);

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin test1");
        boolean pass = false;
        try {
            FullTimeEmployee ftEmp1 = (FullTimeEmployee)this.getEntityManager().find(FullTimeEmployee.class, (Object)1);
            if (ftEmp1.getFullTimeRep().equals("Mabel Murray")) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin test2");
        boolean pass = false;
        try {
            PartTimeEmployee ptEmp1 = (PartTimeEmployee)this.getEntityManager().find(PartTimeEmployee.class, (Object)6);
            if (ptEmp1.getPartTimeRep().equals("John Cleveland")) {
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() {
        TestUtil.logTrace((String)"createTestData");
        try {
            this.getEntityTransaction().begin();
            Client.ftRef[0] = new FullTimeEmployee(1, "Jonathan", "Smith", this.d10, 40000.0f);
            Client.ftRef[1] = new FullTimeEmployee(2, "Mary", "Macy", this.d9, 40000.0f);
            Client.ftRef[2] = new FullTimeEmployee(3, "Sid", "Nee", this.d8, 40000.0f);
            Client.ftRef[3] = new FullTimeEmployee(4, "Julie", "OClaire", this.d7, 60000.0f);
            Client.ftRef[4] = new FullTimeEmployee(5, "Steven", "Rich", this.d6, 60000.0f);
            TestUtil.logTrace((String)"Persist full time employees ");
            for (FullTimeEmployee fullTimeEmployee : ftRef) {
                this.getEntityManager().persist((Object)fullTimeEmployee);
                TestUtil.logTrace((String)("persisted employee " + fullTimeEmployee));
            }
            Client.ptRef[0] = new PartTimeEmployee(6, "Kellie", "Lee", this.d5, 60000.0f);
            Client.ptRef[1] = new PartTimeEmployee(7, "Nicole", "Martin", this.d4, 60000.0f);
            Client.ptRef[2] = new PartTimeEmployee(8, "Mark", "Francis", this.d3, 60000.0f);
            Client.ptRef[3] = new PartTimeEmployee(9, "Will", "Forrest", this.d2, 60000.0f);
            Client.ptRef[4] = new PartTimeEmployee(10, "Katy", "Hughes", this.d1, 60000.0f);
            TestUtil.logTrace((String)"Persist part time employees ");
            for (FullTimeEmployee fullTimeEmployee : ptRef) {
                this.getEntityManager().persist((Object)fullTimeEmployee);
                TestUtil.logTrace((String)("persisted employee " + fullTimeEmployee));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception rolling back TX:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from PARTTIMEEMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

