/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.ClientInterceptorEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import com.sun.ts.tests.interop.csiv2.common.parser.ReplyEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ServerEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ServerInterceptorEntry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClientEntry
extends Entry {
    private ClientInterceptorEntry clientInterceptor;
    private ServerInterceptorEntry serverInterceptor;
    private ServerEntry server;
    private ReplyEntry reply;

    public ClientEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("client")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("client-interceptor")) {
                this.clientInterceptor = new ClientInterceptorEntry((Element)node);
            } else if (node.getNodeName().equals("server-interceptor")) {
                this.serverInterceptor = new ServerInterceptorEntry((Element)node);
            }
            if (node.getNodeName().equals("server")) {
                this.server = new ServerEntry((Element)node);
            }
            if (!node.getNodeName().equals("reply")) continue;
            this.reply = new ReplyEntry((Element)node);
        }
    }

    public ClientInterceptorEntry getClientInterceptor() {
        return this.clientInterceptor;
    }

    public ServerInterceptorEntry getServerInterceptor() {
        return this.serverInterceptor;
    }

    public ServerEntry getServer() {
        return this.server;
    }

    public ReplyEntry getReply() {
        return this.reply;
    }

    public String toString() {
        String result = "<client>\n";
        if (this.clientInterceptor != null) {
            result = result + this.clientInterceptor.toString();
        }
        if (this.serverInterceptor != null) {
            result = result + this.serverInterceptor.toString();
        }
        if (this.server != null) {
            result = result + this.server.toString();
            result = result + this.reply.toString();
        }
        result = result + "</client>\n";
        return result;
    }
}

